/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistrar;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageClassList;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.EmailVerificationUrlServiceDefault;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.apache.isis.viewer.wicket.viewer.imagecache.ImageResourceCacheClassPath;
import org.apache.isis.viewer.wicket.viewer.registries.components.ComponentFactoryRegistrarDefault;
import org.apache.isis.viewer.wicket.viewer.registries.components.ComponentFactoryRegistryDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassListDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageClassRegistryDefault;
import org.apache.isis.viewer.wicket.viewer.registries.pages.PageNavigationServiceDefault;
import org.apache.isis.viewer.wicket.viewer.services.EmailNotificationServiceWicket;
import org.apache.isis.viewer.wicket.viewer.services.EmailServiceWicket;
import org.apache.isis.viewer.wicket.viewer.settings.WicketViewerSettingsDefault;

public class IsisWicketModule
extends AbstractModule {
    private ServletContext servletContext;

    public IsisWicketModule(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void configure() {
        this.bind(ComponentFactoryRegistry.class).to(ComponentFactoryRegistryDefault.class);
        this.bind(PageClassRegistry.class).to(PageClassRegistryDefault.class);
        this.bind(EmailVerificationUrlService.class).to(EmailVerificationUrlServiceDefault.class);
        this.bind(PageNavigationService.class).to(PageNavigationServiceDefault.class);
        this.bind(PageClassList.class).to(PageClassListDefault.class);
        this.bind(ComponentFactoryRegistrar.class).to(ComponentFactoryRegistrarDefault.class);
        this.bind(ImageResourceCache.class).to(ImageResourceCacheClassPath.class);
        this.bind(WicketViewerSettings.class).to(WicketViewerSettingsDefault.class);
        this.bind(EmailService.class).to(EmailServiceWicket.class);
        this.bind(EmailNotificationService.class).to(EmailNotificationServiceWicket.class);
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationName")).toProvider(this.string("isis.viewer.wicket.application.name", "Apache Isis \u2122"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"brandLogoHeader")).toProvider(this.string("isis.viewer.wicket.application.brandLogoHeader"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"brandLogoSignin")).toProvider(this.string("isis.viewer.wicket.application.brandLogoSignin"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationCss")).toProvider(this.string("isis.viewer.wicket.application.css", "css/application.css"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationJs")).toProvider(this.string("isis.viewer.wicket.application.js", "css/application.js"));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"aboutMessage")).toProvider(this.stringOrElse("isis.viewer.wicket.application.about", this.string("isis.viewer.wicket.application.name")));
        Provider<String> welcomeFile = this.string("isis.viewer.wicket.welcome.file", "welcome.html");
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"welcomeMessage")).toProvider(() -> {
            String fallback = this.getConfiguration().getString("isis.viewer.wicket.welcome.text");
            try {
                URL resource = this.servletContext.getResource(_Strings.prefix((String)((String)welcomeFile.get()), (String)"/"));
                if (resource != null) {
                    return IsisWicketApplication.readLines(resource, fallback);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return fallback;
        });
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"applicationVersion")).toProvider(this.string("isis.viewer.wicket.application.version"));
        this.bind(InputStream.class).annotatedWith((Annotation)Names.named((String)"metaInfManifest")).toProvider(() -> this.servletContext.getResourceAsStream("/META-INF/MANIFEST.MF"));
    }

    private Provider<String> string(String key) {
        return () -> this.getConfiguration().getString(key);
    }

    private Provider<String> string(String key, String defaultValue) {
        return () -> this.getConfiguration().getString(key, defaultValue);
    }

    private Provider<String> stringOrElse(String key, Provider<String> fallback) {
        return () -> this.getConfiguration().getString(key, (String)fallback.get());
    }

    private IsisConfiguration getConfiguration() {
        return _Config.getConfiguration();
    }
}

