/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterEntities {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterEntities.class);
    private final _Lazy<Set<String>> entityTypes = _Lazy.threadSafe(this::findEntityTypes);

    public Set<String> getEntityTypes() {
        return (Set)this.entityTypes.get();
    }

    private Set<String> findEntityTypes() {
        LinkedHashSet<String> entityTypes = new LinkedHashSet<String>();
        Set persistenceCapableTypes = AppManifest.Registry.instance().getPersistenceCapableTypes();
        if (persistenceCapableTypes == null) {
            throw new IllegalStateException("AppManifest is required");
        }
        ArrayList classNamesNotEnhanced = _Lists.newArrayList();
        for (Class persistenceCapableType : persistenceCapableTypes) {
            if (RegisterEntities.ignore(persistenceCapableType)) continue;
            if (!JdoMetamodelUtil.isPersistenceEnhanced((Class)persistenceCapableType)) {
                classNamesNotEnhanced.add(persistenceCapableType.getCanonicalName());
            }
            entityTypes.add(persistenceCapableType.getCanonicalName());
        }
        if (!classNamesNotEnhanced.isEmpty()) {
            String classNamesNotEnhancedStr = _NullSafe.stream((Collection)classNamesNotEnhanced).collect(Collectors.joining("\n* "));
            throw new IllegalStateException("Non-enhanced @PersistenceCapable classes found, will abort.  The classes in error are:\n\n* " + classNamesNotEnhancedStr + "\n\nDid the DataNucleus enhancer run correctly?\n");
        }
        return entityTypes;
    }

    private static boolean ignore(Class<?> entityType) {
        try {
            if (entityType.isAnonymousClass() || entityType.isLocalClass() || entityType.isMemberClass() || entityType.isInterface() || entityType.isAnnotation()) {
                return true;
            }
            PersistenceCapable persistenceCapable = entityType.getAnnotation(PersistenceCapable.class);
            return persistenceCapable == null;
        }
        catch (NoClassDefFoundError ex) {
            return true;
        }
    }
}

