/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.isis.applib.services.wrapper.WrappingObject;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ProxyEnhanced;
import org.apache.isis.core.plugins.codegen.ProxyFactory;
import org.apache.isis.core.wrapper.handlers.DelegatingInvocationHandler;

public class ProxyCreator {
    private final Map<Class<?>, ProxyFactory<?>> proxyFactoryByClass;

    public ProxyCreator() {
        this(Collections.synchronizedMap(new WeakHashMap()));
    }

    public ProxyCreator(Map<Class<?>, ProxyFactory<?>> proxyFactoryByClass) {
        this.proxyFactoryByClass = proxyFactoryByClass;
    }

    public <T> T instantiateProxy(DelegatingInvocationHandler<T> handler) {
        T toProxy = handler.getDelegate();
        Class base = (Class)_Casts.uncheckedCast(toProxy.getClass());
        if (base.isInterface()) {
            return ProxyCreator.createInstanceForInterface(base, handler, WrappingObject.class);
        }
        ProxyFactory<T> proxyFactory = this.proxyFactoryFor(base);
        return (T)proxyFactory.createInstance(handler, false);
    }

    private <T> ProxyFactory<T> proxyFactoryFor(Class<T> toProxyClass) {
        ProxyFactory<T> proxyFactory = (ProxyFactory<T>)_Casts.uncheckedCast(this.proxyFactoryByClass.get(toProxyClass));
        if (proxyFactory == null) {
            proxyFactory = this.createProxyFactoryFor(toProxyClass);
            this.proxyFactoryByClass.put(toProxyClass, proxyFactory);
        }
        return proxyFactory;
    }

    private <T> ProxyFactory<T> createProxyFactoryFor(Class<T> toProxyClass) {
        Class[] interfaces = (Class[])ArrayExtensions.combine((Object[][])new Class[][]{toProxyClass.getInterfaces(), {ProxyEnhanced.class, WrappingObject.class}});
        ProxyFactory proxyFactory = ProxyFactory.builder(toProxyClass).interfaces(interfaces).build();
        return proxyFactory;
    }

    private static <T> T createInstanceForInterface(Class<T> base, InvocationHandler handler, Class<?> ... auxiliaryTypes) {
        return (T)Proxy.newProxyInstance(base.getClassLoader(), (Class[])_Arrays.combine(base, (Object[])auxiliaryTypes), handler);
    }
}

