/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.wrapper.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.wrapper.DisabledException;
import org.apache.isis.applib.services.wrapper.HiddenException;
import org.apache.isis.applib.services.wrapper.InteractionException;
import org.apache.isis.applib.services.wrapper.InvalidException;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.wrapper.WrappingObject;
import org.apache.isis.applib.services.wrapper.events.CollectionAccessEvent;
import org.apache.isis.applib.services.wrapper.events.InteractionEvent;
import org.apache.isis.applib.services.wrapper.events.ObjectTitleEvent;
import org.apache.isis.applib.services.wrapper.events.PropertyAccessEvent;
import org.apache.isis.applib.services.wrapper.events.UsabilityEvent;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.applib.services.wrapper.events.VisibilityEvent;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.IsisJdoMetamodelPlugin;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.interactions.ObjectTitleContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.wrapper.handlers.DelegatingInvocationHandlerDefault;
import org.apache.isis.core.wrapper.handlers.ProxyContextHandler;

public class DomainObjectInvocationHandler<T>
extends DelegatingInvocationHandlerDefault<T> {
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    private final ProxyContextHandler proxy;
    private final WrapperFactory.ExecutionMode executionMode;
    private final IsisSessionFactory isisSessionFactory;
    protected Method titleMethod;
    protected Method __isis_saveMethod;
    protected Method __isis_wrappedMethod;
    protected Method __isis_executionMode;
    protected final Set<String> jdoMethodsProvidedByEnhancement = _Sets.newHashSet();
    private final Where where = Where.ANYWHERE;

    public DomainObjectInvocationHandler(T delegate, WrapperFactory.ExecutionMode mode, ProxyContextHandler proxy, IsisSessionFactory isisSessionFactory) {
        super(delegate, mode, isisSessionFactory);
        this.proxy = proxy;
        this.executionMode = mode;
        this.isisSessionFactory = isisSessionFactory;
        ServicesInjector servicesInjector = isisSessionFactory.getServicesInjector();
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
        try {
            this.titleMethod = delegate.getClass().getMethod("title", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.__isis_saveMethod = WrappingObject.class.getMethod("__isis_save", new Class[0]);
            this.__isis_wrappedMethod = WrappingObject.class.getMethod("__isis_wrapped", new Class[0]);
            this.__isis_executionMode = WrappingObject.class.getMethod("__isis_executionMode", new Class[0]);
            _NullSafe.stream((Object[])IsisJdoMetamodelPlugin.get().getMethodsProvidedByEnhancement()).map(Method::getName).forEach(this.jdoMethodsProvidedByEnhancement::add);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("Could not locate reserved declared methods in the WrappingObject and WrappedObject interfaces", nsme);
        }
    }

    @Override
    public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
        if (this.isObjectMethod(method)) {
            return this.delegate(method, args);
        }
        if (this.isJdoMethod(method)) {
            return this.delegate(method, args);
        }
        if (DomainObjectInvocationHandler.isInjectMethod(method)) {
            return this.delegate(method, args);
        }
        ObjectAdapter targetAdapter = this.adapterFor(this.getDelegate());
        if (this.isTitleMethod(method)) {
            return this.handleTitleMethod(targetAdapter);
        }
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        if (this.isSaveMethod(method)) {
            return this.handleSaveMethod(targetAdapter, targetNoSpec);
        }
        if (this.isWrappedMethod(method)) {
            return this.getDelegate();
        }
        if (this.isExecutionModeMethod(method)) {
            return this.executionMode;
        }
        ObjectMember objectMember = this.locateAndCheckMember(method);
        ContributeeMember contributeeMember = this.determineIfContributed(args, objectMember);
        String memberName = objectMember.getName();
        ImperativeFacet.Intent intent = ImperativeFacet.Util.getIntent((ObjectMember)objectMember, (Method)method);
        if (intent == ImperativeFacet.Intent.CHECK_IF_HIDDEN || intent == ImperativeFacet.Intent.CHECK_IF_DISABLED) {
            throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'", memberName));
        }
        if (intent == ImperativeFacet.Intent.DEFAULTS || intent == ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE) {
            return method.invoke(this.getDelegate(), args);
        }
        if (objectMember.isOneToOneAssociation()) {
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID || intent == ImperativeFacet.Intent.MODIFY_PROPERTY_SUPPORTING) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method for '%s'; use only property accessor/mutator", memberName));
            }
            OneToOneAssociation otoa = (OneToOneAssociation)objectMember;
            if (intent == ImperativeFacet.Intent.ACCESSOR) {
                return this.handleGetterMethodOnProperty(targetAdapter, args, otoa);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_PROPERTY || intent == ImperativeFacet.Intent.INITIALIZATION) {
                return this.handleSetterMethodOnProperty(targetAdapter, args, otoa);
            }
        }
        if (objectMember.isOneToManyAssociation()) {
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only collection accessor/mutator", memberName));
            }
            OneToManyAssociation otma = (OneToManyAssociation)objectMember;
            if (intent == ImperativeFacet.Intent.ACCESSOR) {
                return this.handleGetterMethodOnCollection(targetAdapter, args, otma, method, memberName);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_COLLECTION_ADD) {
                return this.handleCollectionAddToMethod(targetAdapter, args, otma);
            }
            if (intent == ImperativeFacet.Intent.MODIFY_COLLECTION_REMOVE) {
                return this.handleCollectionRemoveFromMethod(targetAdapter, args, otma);
            }
        }
        if (objectMember instanceof ObjectAction) {
            ObjectAction actualObjectAction;
            ObjectAdapter actualTargetAdapter;
            if (intent == ImperativeFacet.Intent.CHECK_IF_VALID) {
                throw new UnsupportedOperationException(String.format("Cannot invoke supporting method '%s'; use only the 'invoke' method", memberName));
            }
            ObjectAction objectAction = (ObjectAction)objectMember;
            MixinFacet mixinFacet = (MixinFacet)targetAdapter.getSpecification().getFacet(MixinFacet.class);
            if (mixinFacet != null) {
                actualTargetAdapter = mixinFacet.mixedIn(targetAdapter, MixinFacet.Policy.IGNORE_FAILURES);
                actualObjectAction = DomainObjectInvocationHandler.determineMixinAction(actualTargetAdapter, objectAction);
                if (actualTargetAdapter == null || actualObjectAction == null) {
                    actualTargetAdapter = targetAdapter;
                    actualObjectAction = objectAction;
                }
            } else {
                actualTargetAdapter = targetAdapter;
                actualObjectAction = objectAction;
            }
            return this.handleActionMethod(actualTargetAdapter, args, actualObjectAction, contributeeMember);
        }
        throw new UnsupportedOperationException(String.format("Unknown member type '%s'", objectMember));
    }

    private static ObjectAction determineMixinAction(ObjectAdapter domainObjectAdapter, ObjectAction objectAction) {
        if (domainObjectAdapter == null) {
            return null;
        }
        ObjectSpecification specification = domainObjectAdapter.getSpecification();
        Stream objectActions = specification.streamObjectActions(Contributed.INCLUDED);
        return objectActions.filter(action -> action instanceof ObjectActionMixedIn).map(action -> (ObjectActionMixedIn)action).filter(mixedInAction -> mixedInAction.hasMixinAction(objectAction)).findFirst().orElse(null);
    }

    public InteractionInitiatedBy getInteractionInitiatedBy() {
        return this.getExecutionMode().shouldEnforceRules() ? InteractionInitiatedBy.USER : InteractionInitiatedBy.FRAMEWORK;
    }

    private ContributeeMember determineIfContributed(Object[] args, ObjectMember objectMember) {
        if (!(objectMember instanceof ObjectAction)) {
            return null;
        }
        ObjectAction objectAction = (ObjectAction)objectMember;
        for (Object arg : args) {
            Stream associations;
            Optional<ContributeeMember> contributeeMember;
            if (arg == null) continue;
            ObjectSpecificationDefault objectSpec = this.getJavaSpecification(arg.getClass());
            if (args.length == 1 && (contributeeMember = (associations = objectSpec.streamAssociations(Contributed.INCLUDED)).filter(association -> association instanceof ContributeeMember).map(association -> (ContributeeMember)association).filter(contributeeMember1 -> contributeeMember1.isContributedBy(objectAction)).findAny()).isPresent()) {
                return contributeeMember.get();
            }
            Stream actions = objectSpec.streamObjectActions(Contributed.INCLUDED);
            contributeeMember = actions.filter(action -> action instanceof ContributeeMember).map(action -> (ContributeeMember)action).filter(contributeeMember1 -> contributeeMember1.isContributedBy(objectAction)).findAny();
            if (!contributeeMember.isPresent()) continue;
            return contributeeMember.get();
        }
        return null;
    }

    private boolean isJdoMethod(Method method) {
        return DomainObjectInvocationHandler.methodStartsWith(method, "jdo") || this.jdoMethodsProvidedByEnhancement.contains(method.getName());
    }

    private static boolean isInjectMethod(Method method) {
        return DomainObjectInvocationHandler.methodStartsWith(method, "inject");
    }

    private static boolean methodStartsWith(Method method, String prefix) {
        return method.getName().startsWith(prefix);
    }

    private Object handleTitleMethod(ObjectAdapter targetAdapter) throws IllegalAccessException, InvocationTargetException {
        this.resolveIfRequired(targetAdapter);
        ObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        ObjectTitleContext titleContext = targetNoSpec.createTitleInteractionContext(this.getAuthenticationSession(), InteractionInitiatedBy.FRAMEWORK, (ManagedObject)targetAdapter);
        ObjectTitleEvent titleEvent = titleContext.createInteractionEvent();
        this.notifyListeners((InteractionEvent)titleEvent);
        return titleEvent.getTitle();
    }

    private Object handleSaveMethod(ObjectAdapter targetAdapter, ObjectSpecification targetNoSpec) {
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                InteractionResult interactionResult = targetNoSpec.isValidResult((ManagedObject)targetAdapter, this.getInteractionInitiatedBy());
                this.notifyListenersAndVetoIfRequired(interactionResult);
            } else {
                try {
                    InteractionResult interactionResult = targetNoSpec.isValidResult((ManagedObject)targetAdapter, this.getInteractionInitiatedBy());
                    this.notifyListenersAndVetoIfRequired(interactionResult);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        if (this.getExecutionMode().shouldExecute() && targetAdapter.isTransient()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.getPersistenceSessionService().makePersistent(targetAdapter);
            } else {
                try {
                    this.getPersistenceSessionService().makePersistent(targetAdapter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object handleGetterMethodOnProperty(ObjectAdapter targetAdapter, Object[] args, OneToOneAssociation property) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.checkVisibility(targetAdapter, (ObjectMember)property);
            } else {
                try {
                    this.checkVisibility(targetAdapter, (ObjectMember)property);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        this.resolveIfRequired(targetAdapter);
        InteractionInitiatedBy interactionInitiatedBy = this.getInteractionInitiatedBy();
        ObjectAdapter currentReferencedAdapter = property.get(targetAdapter, interactionInitiatedBy);
        Object currentReferencedObj = ObjectAdapter.Util.unwrapPojo((ManagedObject)currentReferencedAdapter);
        PropertyAccessEvent ev = new PropertyAccessEvent(this.getDelegate(), property.getIdentifier(), currentReferencedObj);
        this.notifyListeners((InteractionEvent)ev);
        return currentReferencedObj;
    }

    private Object handleSetterMethodOnProperty(ObjectAdapter targetAdapter, Object[] args, OneToOneAssociation property) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a setter should only have a single argument");
        }
        Object argumentObj = this.underlying(args[0]);
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.checkVisibility(targetAdapter, (ObjectMember)property);
                this.checkUsability(targetAdapter, (ObjectMember)property);
            } else {
                try {
                    this.checkVisibility(targetAdapter, (ObjectMember)property);
                    this.checkUsability(targetAdapter, (ObjectMember)property);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        ObjectAdapter argumentAdapter = argumentObj != null ? this.adapterFor(argumentObj) : null;
        this.resolveIfRequired(targetAdapter);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = property.isAssociationValid((ManagedObject)targetAdapter, (ManagedObject)argumentAdapter, this.getInteractionInitiatedBy()).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            if (this.getExecutionMode().shouldFailFast()) {
                property.set(targetAdapter, argumentAdapter, this.getInteractionInitiatedBy());
            } else {
                try {
                    property.set(targetAdapter, argumentAdapter, this.getInteractionInitiatedBy());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object handleGetterMethodOnCollection(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation collection, Method method, String memberName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.checkVisibility(targetAdapter, (ObjectMember)collection);
            } else {
                try {
                    this.checkVisibility(targetAdapter, (ObjectMember)collection);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        this.resolveIfRequired(targetAdapter);
        InteractionInitiatedBy interactionInitiatedBy = this.getInteractionInitiatedBy();
        ObjectAdapter currentReferencedAdapter = collection.get(targetAdapter, interactionInitiatedBy);
        Object currentReferencedObj = ObjectAdapter.Util.unwrapPojo((ManagedObject)currentReferencedAdapter);
        CollectionAccessEvent ev = new CollectionAccessEvent(this.getDelegate(), collection.getIdentifier());
        if (currentReferencedObj instanceof Collection) {
            Collection<?> collectionViewObject = this.lookupWrappingObject(method, memberName, (Collection)currentReferencedObj, collection);
            this.notifyListeners((InteractionEvent)ev);
            return collectionViewObject;
        }
        if (currentReferencedObj instanceof Map) {
            Map<?, ?> mapViewObject = this.lookupWrappingObject(memberName, (Map)currentReferencedObj, collection);
            this.notifyListeners((InteractionEvent)ev);
            return mapViewObject;
        }
        throw new IllegalArgumentException(String.format("Collection type '%s' not supported by framework", currentReferencedObj.getClass().getName()));
    }

    private Collection<?> lookupWrappingObject(Method method, String memberName, Collection<?> collectionToLookup, OneToManyAssociation otma) {
        return collectionToLookup instanceof WrappingObject ? collectionToLookup : this.proxy.proxy(collectionToLookup, memberName, this, otma);
    }

    private Map<?, ?> lookupWrappingObject(String memberName, Map<?, ?> mapToLookup, OneToManyAssociation otma) {
        return mapToLookup instanceof WrappingObject ? mapToLookup : this.proxy.proxy(mapToLookup, memberName, this, otma);
    }

    private Object handleCollectionAddToMethod(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation otma) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a addTo should only have a single argument");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.checkVisibility(targetAdapter, (ObjectMember)otma);
                this.checkUsability(targetAdapter, (ObjectMember)otma);
            } else {
                try {
                    this.checkVisibility(targetAdapter, (ObjectMember)otma);
                    this.checkUsability(targetAdapter, (ObjectMember)otma);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to add");
        }
        ObjectAdapter argumentNO = this.adapterFor(argumentObj);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = otma.isValidToAdd(targetAdapter, argumentNO, this.getInteractionInitiatedBy()).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            if (this.getExecutionMode().shouldFailFast()) {
                otma.addElement(targetAdapter, argumentNO, this.getInteractionInitiatedBy());
            } else {
                try {
                    otma.addElement(targetAdapter, argumentNO, this.getInteractionInitiatedBy());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object handleCollectionRemoveFromMethod(ObjectAdapter targetAdapter, Object[] args, OneToManyAssociation collection) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a removeFrom should only have a single argument");
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                this.checkVisibility(targetAdapter, (ObjectMember)collection);
                this.checkUsability(targetAdapter, (ObjectMember)collection);
            } else {
                try {
                    this.checkVisibility(targetAdapter, (ObjectMember)collection);
                    this.checkUsability(targetAdapter, (ObjectMember)collection);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to remove");
        }
        ObjectAdapter argumentAdapter = this.adapterFor(argumentObj);
        if (this.getExecutionMode().shouldEnforceRules()) {
            InteractionResult interactionResult = collection.isValidToRemove(targetAdapter, argumentAdapter, this.getInteractionInitiatedBy()).getInteractionResult();
            this.notifyListenersAndVetoIfRequired(interactionResult);
        }
        if (this.getExecutionMode().shouldExecute()) {
            if (this.getExecutionMode().shouldFailFast()) {
                collection.removeElement(targetAdapter, argumentAdapter, this.getInteractionInitiatedBy());
            } else {
                try {
                    collection.removeElement(targetAdapter, argumentAdapter, this.getInteractionInitiatedBy());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object handleActionMethod(ObjectAdapter targetAdapter, Object[] args, ObjectAction objectAction, ContributeeMember contributeeMember) {
        Object[] contributeeArgs;
        ObjectAdapter contributeeAdapter;
        if (contributeeMember != null) {
            int contributeeParamPosition = contributeeMember.getContributeeParamPosition();
            Object contributee = args[contributeeParamPosition];
            contributeeAdapter = this.adapterFor(contributee);
            List argCopy = _Lists.of((Object[])args);
            argCopy.remove(contributeeParamPosition);
            contributeeArgs = argCopy.toArray();
        } else {
            contributeeAdapter = null;
            contributeeArgs = null;
        }
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (this.getExecutionMode().shouldFailFast()) {
                if (contributeeMember != null) {
                    this.checkVisibility(contributeeAdapter, (ObjectMember)contributeeMember);
                    this.checkUsability(contributeeAdapter, (ObjectMember)contributeeMember);
                } else {
                    this.checkVisibility(targetAdapter, (ObjectMember)objectAction);
                    this.checkUsability(targetAdapter, (ObjectMember)objectAction);
                }
            } else {
                try {
                    if (contributeeMember != null) {
                        this.checkVisibility(contributeeAdapter, (ObjectMember)contributeeMember);
                        this.checkUsability(contributeeAdapter, (ObjectMember)contributeeMember);
                    } else {
                        this.checkVisibility(targetAdapter, (ObjectMember)objectAction);
                        this.checkUsability(targetAdapter, (ObjectMember)objectAction);
                    }
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        ObjectAdapter[] argAdapters = this.asObjectAdaptersUnderlying(args);
        if (this.getExecutionMode().shouldEnforceRules()) {
            if (contributeeMember != null) {
                if (contributeeMember instanceof ObjectActionContributee) {
                    ObjectActionContributee objectActionContributee = (ObjectActionContributee)contributeeMember;
                    ObjectAdapter[] contributeeArgAdapters = this.asObjectAdaptersUnderlying(contributeeArgs);
                    this.checkValidity(contributeeAdapter, (ObjectAction)objectActionContributee, contributeeArgAdapters);
                }
            } else {
                this.checkValidity(targetAdapter, objectAction, argAdapters);
            }
        }
        if (this.getExecutionMode().shouldExecute()) {
            ObjectAdapter returnedAdapter;
            InteractionInitiatedBy interactionInitiatedBy = this.getInteractionInitiatedBy();
            ObjectAdapter mixedInAdapter = null;
            if (this.getExecutionMode().shouldFailFast()) {
                returnedAdapter = objectAction.execute(targetAdapter, mixedInAdapter, argAdapters, interactionInitiatedBy);
            } else {
                try {
                    returnedAdapter = objectAction.execute(targetAdapter, mixedInAdapter, argAdapters, interactionInitiatedBy);
                }
                catch (Exception ignore) {
                    returnedAdapter = null;
                }
            }
            return ObjectAdapter.Util.unwrapPojo((ManagedObject)returnedAdapter);
        }
        return null;
    }

    private void checkValidity(ObjectAdapter targetAdapter, ObjectAction objectAction, ObjectAdapter[] argAdapters) {
        InteractionResult interactionResult = objectAction.isProposedArgumentSetValid(targetAdapter, argAdapters, this.getInteractionInitiatedBy()).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private ObjectAdapter[] asObjectAdaptersUnderlying(Object[] args) {
        ObjectAdapter[] argAdapters = new ObjectAdapter[args.length];
        int i = 0;
        for (Object arg : args) {
            argAdapters[i++] = this.adapterFor(this.underlying(arg));
        }
        return argAdapters;
    }

    private ObjectAdapter adapterFor(Object obj) {
        return obj != null ? this.getObjectAdapterProvider().adapterFor(obj) : null;
    }

    private Object underlying(Object arg) {
        if (arg instanceof WrappingObject) {
            WrappingObject argViewObject = (WrappingObject)arg;
            return argViewObject.__isis_wrapped();
        }
        return arg;
    }

    private void checkVisibility(ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        Consent visibleConsent = objectMember.isVisible((ManagedObject)targetObjectAdapter, this.getInteractionInitiatedBy(), this.where);
        InteractionResult interactionResult = visibleConsent.getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void checkUsability(ObjectAdapter targetObjectAdapter, ObjectMember objectMember) {
        InteractionResult interactionResult = objectMember.isUsable((ManagedObject)targetObjectAdapter, this.getInteractionInitiatedBy(), this.where).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void notifyListenersAndVetoIfRequired(InteractionResult interactionResult) {
        InteractionEvent interactionEvent = interactionResult.getInteractionEvent();
        this.notifyListeners(interactionEvent);
        if (interactionEvent.isVeto()) {
            throw this.toException(interactionEvent);
        }
    }

    private InteractionException toException(InteractionEvent interactionEvent) {
        if (!interactionEvent.isVeto()) {
            throw new IllegalArgumentException("Provided interactionEvent must be a veto");
        }
        if (interactionEvent instanceof ValidityEvent) {
            ValidityEvent validityEvent = (ValidityEvent)interactionEvent;
            return new InvalidException((InteractionEvent)validityEvent);
        }
        if (interactionEvent instanceof VisibilityEvent) {
            VisibilityEvent visibilityEvent = (VisibilityEvent)interactionEvent;
            return new HiddenException((InteractionEvent)visibilityEvent);
        }
        if (interactionEvent instanceof UsabilityEvent) {
            UsabilityEvent usabilityEvent = (UsabilityEvent)interactionEvent;
            return new DisabledException((InteractionEvent)usabilityEvent);
        }
        throw new IllegalArgumentException("Provided interactionEvent must be a VisibilityEvent, UsabilityEvent or a ValidityEvent");
    }

    private ObjectMember locateAndCheckMember(Method method) {
        ObjectSpecificationDefault objectSpecificationDefault = this.getJavaSpecificationOfOwningClass(method);
        ObjectMember member = objectSpecificationDefault.getMember(method);
        if (member == null) {
            String methodName = method.getName();
            throw new UnsupportedOperationException("Method '" + methodName + "' being invoked does not correspond to any of the object's fields or actions.");
        }
        return member;
    }

    protected boolean isTitleMethod(Method method) {
        return method.equals(this.titleMethod);
    }

    protected boolean isSaveMethod(Method method) {
        return method.equals(this.__isis_saveMethod);
    }

    protected boolean isWrappedMethod(Method method) {
        return method.equals(this.__isis_wrappedMethod);
    }

    protected boolean isExecutionModeMethod(Method method) {
        return method.equals(this.__isis_executionMode);
    }

    private ObjectSpecificationDefault getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private ObjectSpecificationDefault getJavaSpecification(Class<?> clazz) {
        ObjectSpecification objectSpec = this.getSpecification(clazz);
        if (!(objectSpec instanceof ObjectSpecificationDefault)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + objectSpec.getClass().getCanonicalName() + "')");
        }
        return (ObjectSpecificationDefault)objectSpec;
    }

    private ObjectSpecification getSpecification(Class<?> type) {
        return this.getSpecificationLoader().loadSpecification(type);
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.isisSessionFactory.getSpecificationLoader();
    }

    public AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.authenticationSessionProvider;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getAuthenticationSessionProvider().getAuthenticationSession();
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.persistenceSessionServiceInternal;
    }

    protected PersistenceSessionServiceInternal getPersistenceSessionService() {
        return this.persistenceSessionServiceInternal;
    }

    public IsisSessionFactory getIsisSessionFactory() {
        return this.isisSessionFactory;
    }
}

