/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.modules;

import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.webapp.modules.WebModule;
import org.apache.isis.core.webapp.modules.WebModuleContext;

final class WebModule_Shiro
implements WebModule {
    private static final String SHIRO_LISTENER_CLASS_NAME = "org.apache.shiro.web.env.EnvironmentLoaderListener";
    private static final String SHIRO_FILTER_CLASS_NAME = "org.apache.shiro.web.servlet.ShiroFilter";
    private static final String SHIRO_FILTER_NAME = "ShiroFilter";

    WebModule_Shiro() {
    }

    @Override
    public String getName() {
        return "Shiro";
    }

    @Override
    public ServletContextListener init(ServletContext ctx) throws ServletException {
        Filter filter;
        try {
            Class<?> filterClass = _Context.getDefaultClassLoader().loadClass(SHIRO_FILTER_CLASS_NAME);
            filter = ctx.createFilter((Class)_Casts.uncheckedCast(filterClass));
        }
        catch (ClassNotFoundException e) {
            throw _Exceptions.unexpectedCodeReach();
        }
        FilterRegistration.Dynamic reg = ctx.addFilter(SHIRO_FILTER_NAME, filter);
        if (reg == null) {
            return null;
        }
        String urlPattern = "/*";
        reg.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        try {
            Class<?> listenerClass = _Context.getDefaultClassLoader().loadClass(SHIRO_LISTENER_CLASS_NAME);
            return (ServletContextListener)ctx.createListener((Class)_Casts.uncheckedCast(listenerClass));
        }
        catch (ClassNotFoundException e) {
            throw _Exceptions.unexpectedCodeReach();
        }
    }

    @Override
    public boolean isApplicable(WebModuleContext ctx) {
        try {
            _Context.getDefaultClassLoader().loadClass(SHIRO_LISTENER_CLASS_NAME);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

