/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.config.AppConfigLocator;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.NotFoundPolicy;
import org.apache.isis.config.builder.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.webapp.modules.WebModule;
import org.apache.isis.core.webapp.modules.WebModuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisWebAppContextListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(IsisWebAppContextListener.class);
    private final List<ServletContextListener> activeListeners = new ArrayList<ServletContextListener>();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        LOG.info("=== PHASE 1 === Setting up ServletContext parameters");
        _Context.setDefaultClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
        _Context.putSingleton(ServletContext.class, (Object)servletContext);
        _Resources.putContextPathIfPresent((String)servletContext.getContextPath());
        IsisConfiguration isisConfiguration = AppConfigLocator.getAppConfig().isisConfiguration();
        WebModuleContext webModuleContext = new WebModuleContext(servletContext);
        List webModules = WebModule.discoverWebModules().peek(module -> module.prepare(webModuleContext)).collect(Collectors.toList());
        LOG.info("=== PHASE 2 === Initializing the ServletContext");
        webModules.stream().filter(module -> module.isApplicable(webModuleContext)).forEach(module -> this.addListener(servletContext, (WebModule)module));
        this.activeListeners.forEach(listener -> listener.contextInitialized(event));
        LOG.info("=== DONE === ServletContext initialized.");
    }

    void addConfigurationResourcesForDeploymentType(IsisConfigurationBuilder isisConfigurationBuilder) {
        String resourceName = IsisContext.getEnvironment().getDeploymentType().name().toLowerCase() + ".properties";
        isisConfigurationBuilder.addConfigurationResource(resourceName, NotFoundPolicy.CONTINUE, IsisConfiguration.ContainsPolicy.IGNORE);
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.activeListeners.forEach(listener -> this.shutdownListener(event, (ServletContextListener)listener));
        this.activeListeners.clear();
    }

    private void addListener(ServletContext context, WebModule module) {
        LOG.info(String.format("Setup ServletContext, adding WebModule '%s'", module.getName()));
        try {
            _With.acceptIfPresent((Object)module.init(context), this.activeListeners::add);
        }
        catch (ServletException e) {
            LOG.error(String.format("Failed to add WebModule '%s' to the ServletContext.", module.getName()), (Throwable)e);
        }
    }

    private void shutdownListener(ServletContextEvent event, ServletContextListener listener) {
        try {
            listener.contextDestroyed(event);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to shutdown WebListener '%s'.", listener.getClass().getName()), (Throwable)e);
        }
    }
}

