/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.progmodel.FacetFactorySet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModelAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.ReflectorConstants;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderBuilder;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderHelper_UsingInstallers;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5;

public final class IsisComponentProvider {
    private final AppManifest appManifest;
    protected final List<Object> services;
    protected final AuthenticationManager authenticationManager;
    protected final AuthorizationManager authorizationManager;

    public static IsisComponentProviderBuilder builder(AppManifest appManifest) {
        return new IsisComponentProviderBuilder().appManifest(appManifest);
    }

    public static IsisComponentProviderBuilder builderUsingInstallers(AppManifest appManifest) {
        IsisComponentProviderHelper_UsingInstallers helper = new IsisComponentProviderHelper_UsingInstallers(appManifest);
        return IsisComponentProvider.builder(appManifest).authenticationManager(helper.authenticationManager).authorizationManager(helper.authorizationManager);
    }

    IsisComponentProvider(AppManifest appManifest, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager) {
        this.appManifest = (AppManifest)_With.requires((Object)appManifest, (String)"appManifest");
        this.services = new ServicesInstallerFromConfigurationAndAnnotation().getServices();
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
    }

    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    public AuthenticationManager provideAuthenticationManager() {
        return this.authenticationManager;
    }

    public AuthorizationManager provideAuthorizationManager() {
        return this.authorizationManager;
    }

    public ServicesInjector provideServiceInjector() {
        return ServicesInjector.builder().addServices(this.services).build();
    }

    public SpecificationLoader provideSpecificationLoader(ServicesInjector servicesInjector, Collection<MetaModelRefiner> metaModelRefiners) throws IsisSystemException {
        IsisConfiguration configuration = _Config.getConfiguration();
        ProgrammingModel programmingModel = this.createProgrammingModel(configuration);
        MetaModelValidator mmv = this.createMetaModelValidator(configuration);
        return JavaReflectorHelper.createObjectReflector((ProgrammingModel)programmingModel, metaModelRefiners, (MetaModelValidator)mmv, (ServicesInjector)servicesInjector);
    }

    protected MetaModelValidator createMetaModelValidator(IsisConfiguration configuration) {
        String metaModelValidatorClassName = configuration.getString("isis.reflector.validator", ReflectorConstants.META_MODEL_VALIDATOR_CLASS_NAME_DEFAULT);
        return (MetaModelValidator)InstanceUtil.createInstance((String)metaModelValidatorClassName, MetaModelValidator.class, (Object[])new Object[0]);
    }

    protected ProgrammingModel createProgrammingModel(IsisConfiguration configuration) {
        ProgrammingModelAbstract.DeprecatedPolicy deprecatedPolicy = ProgrammingModelAbstract.DeprecatedPolicy.parse((IsisConfiguration)configuration);
        ProgrammingModelFacetsJava5 programmingModel = new ProgrammingModelFacetsJava5(deprecatedPolicy);
        FacetFactorySet.Util.includeFacetFactories((IsisConfiguration)configuration, (FacetFactorySet)programmingModel);
        FacetFactorySet.Util.excludeFacetFactories((IsisConfiguration)configuration, (FacetFactorySet)programmingModel);
        return programmingModel;
    }
}

