/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.confview.ConfigurationViewService;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsDefault;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.config.services.view.ConfigurationViewServiceDefault;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.core.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactoryMetamodelRefiner;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.runtime.threadpool.ThreadPoolSupport;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;
import org.apache.isis.schema.utils.ChangesDtoUtils;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.InteractionDtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSessionFactoryBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSessionFactoryBuilder.class);
    private boolean initialized = false;
    private final IsisComponentProvider componentProvider;
    private final AppManifest appManifest;
    private final IsisLocaleInitializer localeInitializer;
    private final IsisTimeZoneInitializer timeZoneInitializer;

    public IsisSessionFactoryBuilder(IsisComponentProvider componentProvider) {
        this.componentProvider = componentProvider;
        this.appManifest = componentProvider.getAppManifest();
        this.localeInitializer = new IsisLocaleInitializer();
        this.timeZoneInitializer = new IsisTimeZoneInitializer();
    }

    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    public IsisSessionFactory buildSessionFactory() {
        IsisSessionFactory isisSessionFactory;
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        LOG.info("initialising Isis System");
        LOG.info("working directory: {}", (Object)new File(".").getAbsolutePath());
        IsisConfiguration configuration = _Config.getConfiguration();
        LOG.info("resource stream source: {}", (Object)configuration.getResourceStreamSource());
        this.localeInitializer.initLocale(configuration);
        this.timeZoneInitializer.initTimeZone(configuration);
        if (_Context.isPrototyping() && !Clock.isInitialized()) {
            FixtureClock.initialize();
        }
        try {
            ServicesInjector servicesInjector = this.componentProvider.provideServiceInjector();
            servicesInjector.addFallbackIfRequired(ConfigurationViewService.class, (Object)new ConfigurationViewServiceDefault());
            servicesInjector.addFallbackIfRequired(FixtureScripts.class, (Object)new FixtureScriptsDefault());
            final AuthenticationManager authenticationManager = this.componentProvider.provideAuthenticationManager();
            servicesInjector.addFallbackIfRequired(AuthenticationManager.class, (Object)authenticationManager);
            final AuthorizationManager authorizationManager = this.componentProvider.provideAuthorizationManager();
            servicesInjector.addFallbackIfRequired(AuthorizationManager.class, (Object)authorizationManager);
            Collection<MetaModelRefiner> metaModelRefiners = IsisSessionFactoryBuilder.refiners(authenticationManager, authorizationManager, new PersistenceSessionFactoryMetamodelRefiner());
            final SpecificationLoader specificationLoader = this.componentProvider.provideSpecificationLoader(servicesInjector, metaModelRefiners);
            servicesInjector.addFallbackIfRequired(SpecificationLoader.class, (Object)specificationLoader);
            final PersistenceSessionFactory persistenceSessionFactory = PersistenceSessionFactory.get();
            servicesInjector.addFallbackIfRequired(PersistenceSessionFactory.class, (Object)persistenceSessionFactory);
            servicesInjector.validateServices();
            isisSessionFactory = new IsisSessionFactory(servicesInjector, this.appManifest);
            servicesInjector.addFallbackIfRequired(IsisSessionFactory.class, (Object)isisSessionFactory);
            servicesInjector.autowire();
            _Context.putSingleton(IsisSessionFactory.class, (Object)isisSessionFactory);
            List futures = ThreadPoolSupport.getInstance().invokeAll(Arrays.asList(new Callable<Object>(){

                @Override
                public Object call() {
                    specificationLoader.init();
                    authenticationManager.init();
                    authorizationManager.init();
                    return null;
                }

                public String toString() {
                    return "SpecificationLoader#init()";
                }
            }, new Callable<Object>(){

                @Override
                public Object call() {
                    persistenceSessionFactory.init();
                    return null;
                }

                public String toString() {
                    return "persistenceSessionFactory#init()";
                }
            }, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ChangesDtoUtils.init();
                    return null;
                }

                public String toString() {
                    return "ChangesDtoUtils.init()";
                }
            }, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    InteractionDtoUtils.init();
                    return null;
                }

                public String toString() {
                    return "InteractionDtoUtils.init()";
                }
            }, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CommandDtoUtils.init();
                    return null;
                }

                public String toString() {
                    return "CommandDtoUtils.init()";
                }
            }));
            ThreadPoolSupport.getInstance().joinGatherFailures(futures);
            persistenceSessionFactory.catalogNamedQueries(specificationLoader);
            isisSessionFactory.constructServices();
            isisSessionFactory.doInSession(() -> {
                try {
                    specificationLoader.validateAndAssert();
                }
                catch (MetaModelInvalidException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Meta model invalid", (Throwable)ex);
                    }
                    _Context.putSingleton(MetaModelInvalidException.class, (Object)((Object)ex));
                }
            });
        }
        catch (IsisSystemException ex) {
            LOG.error("failed to initialise", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return isisSessionFactory;
    }

    private static Collection<MetaModelRefiner> refiners(Object ... possibleRefiners) {
        return ListExtensions.filtered(Arrays.asList(possibleRefiners), MetaModelRefiner.class);
    }

    public boolean isMetaModelValid() {
        return IsisContext.getMetaModelInvalidExceptionIfAny() == null;
    }
}

