/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.factories.OidFactory;

class OidFactory_Builder
implements OidFactory.OidFactoryBuilder {
    private final List<OidFactory.OidProvider> handler = new ArrayList<OidFactory.OidProvider>();
    private final Function<Object, ObjectSpecification> specProvider;

    public OidFactory_Builder(Function<Object, ObjectSpecification> specProvider) {
        this.specProvider = specProvider;
    }

    @Override
    public OidFactory.OidFactoryBuilder add(OidFactory.OidProvider oidProvider) {
        this.handler.add(oidProvider);
        return this;
    }

    @Override
    public OidFactory build() {
        return pojo -> {
            ObjectSpecification spec = this.specProvider.apply(pojo);
            RootOid rootOid = this.handler.stream().filter(h -> h.isHandling(pojo, spec)).findFirst().map(h -> h.oidFor(pojo, spec)).orElse(null);
            Objects.requireNonNull(rootOid, () -> "Could not create an Oid for pojo: " + pojo);
            return rootOid;
        };
    }
}

