/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.UUID;
import org.apache.isis.core.metamodel.IsisJdoMetamodelPlugin;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.factories.OidFactory;

class ObjectAdapterContext_OidProviders {
    ObjectAdapterContext_OidProviders() {
    }

    static class OidForOthers
    implements OidFactory.OidProvider {
        OidForOthers() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            return true;
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            String identifier = UUID.randomUUID().toString();
            return Oid.Factory.transientOf((ObjectSpecId)spec.getSpecId(), (String)identifier);
        }
    }

    static class OidForViewModels
    implements OidFactory.OidProvider {
        OidForViewModels() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            return spec.containsFacet(ViewModelFacet.class);
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            ViewModelFacet recreatableObjectFacet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
            String identifier = recreatableObjectFacet.memento(pojo);
            return Oid.Factory.viewmodelOf((ObjectSpecId)spec.getSpecId(), (String)identifier);
        }
    }

    static class OidForValues
    implements OidFactory.OidProvider {
        OidForValues() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            return spec.containsFacet(ValueFacet.class);
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            return Oid.Factory.value();
        }
    }

    static class OidForPersistent
    implements OidFactory.OidProvider {
        private final IsisJdoMetamodelPlugin isisJdoMetamodelPlugin = IsisJdoMetamodelPlugin.get();

        OidForPersistent() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            boolean isInstanceOfPersistable = this.isisJdoMetamodelPlugin.isPersistenceEnhanced(pojo.getClass());
            return isInstanceOfPersistable;
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            PersistenceSession persistenceSession = IsisContext.getPersistenceSession().get();
            boolean isRecognized = persistenceSession.isRecognized(pojo);
            if (isRecognized) {
                String identifier = persistenceSession.identifierFor(pojo);
                return Oid.Factory.persistentOf((ObjectSpecId)spec.getSpecId(), (String)identifier);
            }
            String identifier = UUID.randomUUID().toString();
            return Oid.Factory.transientOf((ObjectSpecId)spec.getSpecId(), (String)identifier);
        }
    }

    static class OidForServices
    implements OidFactory.OidProvider {
        OidForServices() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            return spec.isService();
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            String identifier = "1";
            return Oid.Factory.persistentOf((ObjectSpecId)spec.getSpecId(), (String)"1");
        }
    }

    static class GuardAgainstRootOid
    implements OidFactory.OidProvider {
        GuardAgainstRootOid() {
        }

        @Override
        public boolean isHandling(Object pojo, ObjectSpecification spec) {
            return pojo instanceof RootOid;
        }

        @Override
        public RootOid oidFor(Object pojo, ObjectSpecification spec) {
            throw new IllegalArgumentException("Cannot create a RootOid for pojo, when pojo is instance of RootOid. You might want to ask ObjectAdapterByIdProvider for an ObjectAdapter instead.");
        }
    }
}

