/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterByIdProvider;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.PojoRecreationException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_ObjectAdapterByIdProvider
implements ObjectAdapterByIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_ObjectAdapterByIdProvider.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationSession authenticationSession;
    private final boolean concurrencyCheckingGloballyEnabled;

    ObjectAdapterContext_ObjectAdapterByIdProvider(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession, AuthenticationSession authenticationSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
        this.authenticationSession = authenticationSession;
        this.concurrencyCheckingGloballyEnabled = !ConcurrencyChecking.isGloballyDisabled((IsisConfiguration)persistenceSession.getConfiguration());
    }

    public ObjectAdapter adapterFor(RootOid rootOid, ConcurrencyChecking concurrencyChecking) {
        ObjectAdapter adapter;
        ObjectAdapter serviceAdapter = this.objectAdapterContext.lookupServiceAdapterFor(rootOid);
        if (serviceAdapter != null) {
            return serviceAdapter;
        }
        try {
            Object pojo = rootOid.isTransient() || rootOid.isViewModel() ? this.recreatePojoTransientOrViewModel(rootOid) : this.persistenceSession.fetchPersistentPojo(rootOid);
            adapter = this.objectAdapterContext.recreatePojo((Oid)rootOid, pojo);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new PojoRecreationException((Oid)rootOid, (Throwable)ex);
        }
        this.syncVersion(concurrencyChecking, adapter, rootOid);
        return adapter;
    }

    public Map<RootOid, ObjectAdapter> adaptersFor(Stream<RootOid> rootOids, ConcurrencyChecking concurrencyChecking) {
        LinkedHashMap adapterByOid = _Maps.newLinkedHashMap();
        ArrayList notYetLoadedOids = _Lists.newArrayList();
        rootOids.forEach(rootOid -> {
            ObjectAdapter adapter = null;
            if (rootOid.isTransient() || rootOid.isViewModel()) {
                Object pojo = this.recreatePojoTransientOrViewModel((RootOid)rootOid);
                adapter = this.objectAdapterContext.recreatePojo((Oid)rootOid, pojo);
                this.syncVersion(concurrencyChecking, adapter, (RootOid)rootOid);
            }
            if (adapter != null) {
                adapterByOid.put(rootOid, adapter);
            } else {
                notYetLoadedOids.add(rootOid);
            }
        });
        Map<RootOid, Object> pojoByOid = this.persistenceSession.fetchPersistentPojos(notYetLoadedOids);
        for (Map.Entry<RootOid, Object> entry : pojoByOid.entrySet()) {
            ObjectAdapter adapter;
            RootOid rootOid2 = entry.getKey();
            Object pojo = entry.getValue();
            if (pojo == null) continue;
            try {
                adapter = this.objectAdapterContext.recreatePojo((Oid)rootOid2, pojo);
                adapterByOid.put(rootOid2, adapter);
            }
            catch (ObjectNotFoundException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new PojoRecreationException((Oid)rootOid2, (Throwable)ex);
            }
            this.syncVersion(concurrencyChecking, adapter, rootOid2);
        }
        return adapterByOid;
    }

    private Object recreatePojoTransientOrViewModel(RootOid rootOid) {
        Object pojo;
        ObjectSpecification spec = this.specificationLoader.lookupBySpecId(rootOid.getObjectSpecId());
        if (rootOid.isViewModel()) {
            String memento = rootOid.getIdentifier();
            pojo = this.recreateViewModel(spec, memento);
        } else {
            pojo = this.objectAdapterContext.instantiateAndInjectServices(spec);
        }
        Ensure.ensure((String)"unlikely", (!(pojo instanceof Oid) ? 1 : 0) != 0);
        return pojo;
    }

    private Object recreateViewModel(ObjectSpecification spec, String memento) {
        Object viewModelPojo;
        ViewModelFacet facet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
        if (facet == null) {
            throw new IllegalArgumentException("spec does not have ViewModelFacet; spec is " + spec.getFullIdentifier());
        }
        if (facet.getRecreationMechanism().isInitializes()) {
            viewModelPojo = this.objectAdapterContext.instantiateAndInjectServices(spec);
            facet.initialize(viewModelPojo, memento);
        } else {
            viewModelPojo = facet.instantiate(spec.getCorrespondingClass(), memento);
        }
        return viewModelPojo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncVersion(ConcurrencyChecking concurrencyChecking, ObjectAdapter adapter, RootOid rootOid) {
        Oid adapterOid = adapter.getOid();
        if (adapterOid instanceof RootOid) {
            RootOid originalOid;
            RootOid recreatedOid;
            block8: {
                recreatedOid = (RootOid)adapterOid;
                originalOid = rootOid;
                try {
                    if (!concurrencyChecking.isChecking()) break block8;
                    Version otherVersion = originalOid.getVersion();
                    Version thisVersion = recreatedOid.getVersion();
                    if (thisVersion == null || otherVersion == null || !thisVersion.different(otherVersion)) break block8;
                    if (this.concurrencyCheckingGloballyEnabled && ConcurrencyChecking.isCurrentlyEnabled()) {
                        LOG.info("concurrency conflict detected on {} ({})", (Object)recreatedOid, (Object)otherVersion);
                        String currentUser = this.authenticationSession.getUserName();
                        throw new ConcurrencyException(currentUser, (Oid)recreatedOid, thisVersion, otherVersion);
                    }
                    LOG.info("concurrency conflict detected but suppressed, on {} ({})", (Object)recreatedOid, (Object)otherVersion);
                }
                catch (Throwable throwable) {
                    Version originalVersion = originalOid.getVersion();
                    Version recreatedVersion = recreatedOid.getVersion();
                    if (recreatedVersion != null && (originalVersion == null || recreatedVersion.different(originalVersion))) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("updating version in oid, on {} ({}) to ({})", new Object[]{originalOid, originalVersion, recreatedVersion});
                        }
                        originalOid.setVersion(recreatedVersion);
                    }
                    throw throwable;
                }
            }
            Version originalVersion = originalOid.getVersion();
            Version recreatedVersion = recreatedOid.getVersion();
            if (recreatedVersion != null && (originalVersion == null || recreatedVersion.different(originalVersion))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("updating version in oid, on {} ({}) to ({})", new Object[]{originalOid, originalVersion, recreatedVersion});
                }
                originalOid.setVersion(recreatedVersion);
            }
        }
    }
}

