/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_NewIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_NewIdentifier.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;

    ObjectAdapterContext_NewIdentifier(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
    }

    final RootOid createPersistentOid(Object pojo) {
        ObjectSpecification spec = this.specificationLoader.loadSpecification(pojo.getClass());
        String identifier = this.persistenceSession.identifierFor(pojo);
        ObjectSpecId objectSpecId = spec.getSpecId();
        return Oid.Factory.persistentOf((ObjectSpecId)objectSpecId, (String)identifier);
    }
}

