/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import org.apache.isis.applib.events.lifecycle.AbstractLifecycleEvent;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facets.object.callbacks.LifecycleEventFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_LifecycleEventSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_LifecycleEventSupport.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;
    private final SpecificationLoader specificationLoader;
    private final EventBusService eventBusService;

    ObjectAdapterContext_LifecycleEventSupport(ObjectAdapterContext objectAdapterContext, PersistenceSession persistenceSession) {
        this.objectAdapterContext = objectAdapterContext;
        this.persistenceSession = persistenceSession;
        this.servicesInjector = persistenceSession.getServicesInjector();
        this.specificationLoader = this.servicesInjector.getSpecificationLoader();
        this.eventBusService = (EventBusService)this.servicesInjector.lookupServiceElseFail(EventBusService.class);
    }

    void postLifecycleEventIfRequired(ManagedObject adapter, Class<? extends LifecycleEventFacet> lifecycleEventFacetClass) {
        LifecycleEventFacet facet = (LifecycleEventFacet)adapter.getSpecification().getFacet(lifecycleEventFacetClass);
        if (facet != null) {
            Class eventType = facet.getEventType();
            Object instance = InstanceUtil.createInstance((Class)eventType, (Object[])new Object[0]);
            Object pojo = adapter.getPojo();
            this.postEvent((AbstractLifecycleEvent<Object>)((AbstractLifecycleEvent)instance), pojo);
        }
    }

    private void postEvent(AbstractLifecycleEvent<Object> event, Object pojo) {
        if (this.eventBusService != null) {
            event.setSource(pojo);
            this.eventBusService.post(event);
        }
    }
}

