/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.List;
import java.util.Map;
import javax.jdo.PersistenceManager;
import org.apache.isis.applib.query.Query;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterByIdProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;

public interface PersistenceSession
extends ObjectAdapterProvider.Delegating,
ObjectAdapterByIdProvider.Delegating,
TransactionalResource,
SessionScopedComponent {
    public static final String SERVICE_IDENTIFIER = "1";
    public static final String INSTALL_FIXTURES_KEY = "isis.persistor.datanucleus.install-fixtures";
    public static final boolean INSTALL_FIXTURES_DEFAULT = false;

    public IsisConfiguration getConfiguration();

    public IsisTransactionManager getTransactionManager();

    public ServicesInjector getServicesInjector();

    public void open();

    public void close();

    default public boolean flush() {
        return this.getTransactionManager().flushTransaction();
    }

    public void refreshRoot(Object var1);

    default public void refreshRootInTransaction(Object domainObject) {
        this.getTransactionManager().executeWithinTransaction(() -> this.refreshRoot(domainObject));
    }

    public String identifierFor(Object var1);

    public boolean isTransient(Object var1);

    public boolean isRepresentingPersistent(Object var1);

    public boolean isDestroyed(Object var1);

    public boolean isRecognized(Object var1);

    public Object fetchPersistentPojo(RootOid var1);

    default public Object fetchPersistentPojoInTransaction(RootOid oid) {
        return this.getTransactionManager().executeWithinTransaction(() -> this.fetchPersistentPojo(oid));
    }

    public Map<RootOid, Object> fetchPersistentPojos(List<RootOid> var1);

    public PersistenceManager getPersistenceManager();

    default public PersistenceManager pm() {
        return this.getPersistenceManager();
    }

    default public <T> javax.jdo.Query newJdoNamedQuery(Class<T> cls, String queryName) {
        return this.pm().newNamedQuery(cls, queryName);
    }

    default public <T> javax.jdo.Query newJdoQuery(Class<T> cls) {
        return this.pm().newQuery(cls);
    }

    default public <T> javax.jdo.Query newJdoQuery(Class<T> cls, String filter) {
        return this.pm().newQuery(cls, filter);
    }

    public boolean isFixturesInstalled();

    public ObjectAdapterContext.MementoRecreateObjectSupport mementoSupport();

    public <T> List<ObjectAdapter> allMatchingQuery(Query<T> var1);

    public <T> ObjectAdapter firstMatchingQuery(Query<T> var1);

    public void destroyObjectInTransaction(ObjectAdapter var1);

    public void makePersistentInTransaction(ObjectAdapter var1);

    public void execute(List<PersistenceCommand> var1);

    public long getLifecycleStartedAtSystemNanos();
}

