/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.context;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.ConfigurationConstants;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.plugins.environment.IsisSystemEnvironment;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

public interface IsisContext {
    public static MetaModelInvalidException getMetaModelInvalidExceptionIfAny() {
        return (MetaModelInvalidException)_Context.getIfAny(MetaModelInvalidException.class);
    }

    public static IsisSessionFactory getSessionFactory() {
        return (IsisSessionFactory)_Context.getOrThrow(IsisSessionFactory.class, () -> new IllegalStateException("internal error: should have been populated by IsisSessionFactoryBuilder"));
    }

    public static ClassLoader getClassLoader() {
        return _Context.getDefaultClassLoader();
    }

    public static <T> CompletableFuture<T> compute(Supplier<T> computation) {
        return CompletableFuture.supplyAsync(computation);
    }

    public static IsisSystemEnvironment getEnvironment() {
        return _Context.getEnvironment();
    }

    public static void clear() {
        _Context.clear();
    }

    public static Optional<PersistenceSession> getPersistenceSession() {
        return Optional.ofNullable(IsisContext.getSessionFactory().getCurrentSession()).map(IsisSession::getPersistenceSession);
    }

    public static IsisConfiguration getConfiguration() {
        return IsisContext.getSessionFactory().getConfiguration();
    }

    public static SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSessionFactory().getSpecificationLoader();
    }

    public static ServicesInjector getServicesInjector() {
        return IsisContext.getSessionFactory().getServicesInjector();
    }

    public static StringBuilder dumpConfig() {
        IsisConfiguration configuration;
        StringBuilder sb = new StringBuilder();
        try {
            configuration = IsisContext.getConfiguration();
        }
        catch (Exception e) {
            return sb;
        }
        Map map = ConfigurationConstants.maskIfProtected((Map)configuration.asMap(), TreeMap::new);
        String head = String.format("ISIS %s (%s) ", IsisConfiguration.getVersion(), IsisContext.getEnvironment().getDeploymentType().name());
        int fillCount = 46 - head.length();
        int fillLeft = fillCount / 2;
        int fillRight = fillCount - fillLeft;
        head = _Strings.padStart((String)"", (int)fillLeft, (char)' ') + head + _Strings.padEnd((String)"", (int)fillRight, (char)' ');
        sb.append("================================================\n");
        sb.append("=" + head + "=\n");
        sb.append("================================================\n");
        map.forEach((k, v) -> sb.append(k + " -> " + v).append("\n"));
        sb.append("================================================\n");
        return sb;
    }
}

