/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.sessiontemplate;

import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.security.authentication.AuthenticationSession;

public abstract class AbstractIsisSessionTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AuthenticationSession authSession, Object context) {
        try {
            this.getIsisSessionFactory().openSession(authSession);
            PersistenceSession persistenceSession = this.getPersistenceSession();
            persistenceSession.getServicesInjector().injectServicesInto((Object)this);
            this.doExecute(context);
        }
        finally {
            this.getIsisSessionFactory().closeSession();
        }
    }

    protected void doExecute(Object context) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        IsisTransactionManager transactionManager = this.getTransactionManager(persistenceSession);
        transactionManager.executeWithinTransaction(() -> this.doExecuteWithTransaction(context));
    }

    protected void doExecuteWithTransaction(Object context) {
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisTransactionManager getTransactionManager(PersistenceSession persistenceSession) {
        return persistenceSession.getTransactionManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

