/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.xactn;

import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.xactn.Transaction;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class TransactionServiceDefault
implements TransactionService {
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public void flushTransaction() {
        this.persistenceSessionServiceInternal.flush();
    }

    public void nextTransaction() {
        this.nextTransaction((Command)null);
    }

    public void nextTransaction(Command commandIfAny) {
        this.nextTransaction(TransactionService.Policy.UNLESS_MARKED_FOR_ABORT, commandIfAny);
    }

    public void nextTransaction(TransactionService.Policy policy) {
        this.nextTransaction(policy, null);
    }

    public void nextTransaction(TransactionService.Policy policy, Command commandIfAny) {
        TransactionState transactionState = this.getTransactionState();
        switch (transactionState) {
            case NONE: {
                break;
            }
            case IN_PROGRESS: {
                this.persistenceSessionServiceInternal.commit();
                break;
            }
            case MUST_ABORT: {
                switch (policy) {
                    case UNLESS_MARKED_FOR_ABORT: {
                        throw new IsisException("Transaction is marked to abort");
                    }
                    case ALWAYS: {
                        this.persistenceSessionServiceInternal.abortTransaction();
                        Transaction currentTransaction = this.currentTransaction();
                        if (!(currentTransaction instanceof IsisTransaction)) break;
                        ((IsisTransaction)currentTransaction).clearAbortCause();
                    }
                }
                break;
            }
            case COMMITTED: {
                break;
            }
        }
        this.persistenceSessionServiceInternal.beginTran(commandIfAny);
    }

    public Transaction currentTransaction() {
        return this.persistenceSessionServiceInternal.currentTransaction();
    }

    public CountDownLatch currentTransactionLatch() {
        return this.persistenceSessionServiceInternal.currentTransactionLatch();
    }

    public TransactionState getTransactionState() {
        return this.persistenceSessionServiceInternal.getTransactionState();
    }
}

