/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.publish;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishingChangeKind;
import org.apache.isis.applib.services.RepresentsInteractionMemberExecution;
import org.apache.isis.applib.services.publish.PublishedObjects;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Multimaps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.schema.chg.v1.ChangesDto;
import org.apache.isis.schema.chg.v1.ObjectsDto;
import org.apache.isis.schema.common.v1.OidsDto;
import org.apache.isis.schema.utils.jaxbadapters.JavaSqlTimestampXmlGregorianCalendarAdapter;

public class PublishedObjectsDefault
implements PublishedObjects,
RepresentsInteractionMemberExecution {
    private UUID transactionUuid;
    private final int sequence;
    private final String userName;
    private final Timestamp completedAt;
    private final int numberLoaded;
    private final int numberObjectPropertiesModified;
    private final Map<ObjectAdapter, PublishingChangeKind> changesByAdapter;
    private ChangesDto dto;
    private _Lazy<_Multimaps.ListMultimap<PublishingChangeKind, ObjectAdapter>> adaptersByChange = _Lazy.of(this::initAdaptersByChange);

    public PublishedObjectsDefault(UUID transactionUuid, int sequence, String userName, Timestamp completedAt, int numberLoaded, int numberObjectPropertiesModified, Map<ObjectAdapter, PublishingChangeKind> changesByAdapter) {
        this.transactionUuid = transactionUuid;
        this.sequence = sequence;
        this.userName = userName;
        this.completedAt = completedAt;
        this.numberLoaded = numberLoaded;
        this.numberObjectPropertiesModified = numberObjectPropertiesModified;
        this.changesByAdapter = changesByAdapter;
    }

    @Programmatic
    public UUID getTransactionId() {
        return this.getUniqueId();
    }

    @Programmatic
    public UUID getUniqueId() {
        return this.transactionUuid;
    }

    @Programmatic
    public int getSequence() {
        return this.sequence;
    }

    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    public String getUsername() {
        return this.userName;
    }

    public ChangesDto getDto() {
        return this.dto != null ? this.dto : (this.dto = this.newDto());
    }

    public int getNumberLoaded() {
        return this.numberLoaded;
    }

    public int getNumberCreated() {
        return this.numAdaptersOfKind(PublishingChangeKind.CREATE);
    }

    public int getNumberUpdated() {
        return this.numAdaptersOfKind(PublishingChangeKind.UPDATE);
    }

    public int getNumberDeleted() {
        return this.numAdaptersOfKind(PublishingChangeKind.DELETE);
    }

    public int getNumberPropertiesModified() {
        return this.numberObjectPropertiesModified;
    }

    private int numAdaptersOfKind(PublishingChangeKind kind) {
        Collection objectAdapters = (Collection)((_Multimaps.ListMultimap)this.adaptersByChange.get()).get((Object)kind);
        return objectAdapters != null ? objectAdapters.size() : 0;
    }

    private _Multimaps.ListMultimap<PublishingChangeKind, ObjectAdapter> initAdaptersByChange() {
        return _Maps.invertToListMultimap(this.changesByAdapter);
    }

    private ChangesDto newDto() {
        ObjectsDto objectsDto = this.newObjectsDto();
        return this.newChangesDto(objectsDto);
    }

    protected ObjectsDto newObjectsDto() {
        ObjectsDto objectsDto = new ObjectsDto();
        objectsDto.setCreated(this.oidsDtoFor(PublishingChangeKind.CREATE));
        objectsDto.setUpdated(this.oidsDtoFor(PublishingChangeKind.UPDATE));
        objectsDto.setDeleted(this.oidsDtoFor(PublishingChangeKind.DELETE));
        objectsDto.setLoaded(this.getNumberLoaded());
        objectsDto.setPropertiesModified(this.getNumberPropertiesModified());
        return objectsDto;
    }

    private OidsDto oidsDtoFor(PublishingChangeKind kind) {
        OidsDto oidsDto = new OidsDto();
        Collection adapters = (Collection)((_Multimaps.ListMultimap)this.adaptersByChange.get()).get((Object)kind);
        if (adapters != null) {
            List oidDtos = _Lists.map((Collection)adapters, objectAdapter -> {
                RootOid rootOid = (RootOid)objectAdapter.getOid();
                return rootOid.asOidDto();
            });
            oidsDto.getOid().addAll(oidDtos);
        }
        return oidsDto;
    }

    protected ChangesDto newChangesDto(ObjectsDto objectsDto) {
        ChangesDto changesDto = new ChangesDto();
        changesDto.setMajorVersion("1");
        changesDto.setMinorVersion("0");
        changesDto.setTransactionId(this.transactionUuid.toString());
        changesDto.setSequence(this.sequence);
        changesDto.setUser(this.userName);
        changesDto.setCompletedAt(JavaSqlTimestampXmlGregorianCalendarAdapter.print((Timestamp)this.completedAt));
        changesDto.setObjects(objectsDto);
        return changesDto;
    }
}

