/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.menubars;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBars;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.menu.MenuBarsLoaderService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class MenuBarsLoaderServiceDefault
implements MenuBarsLoaderService {
    private static final Logger log = LoggerFactory.getLogger(MenuBarsLoaderServiceDefault.class);
    private static final String menubarsLayoutResourceName = "menubars.layout.xml";
    private boolean warnedOnce = false;
    @Inject
    JaxbService jaxbService;
    @Inject
    IsisSessionFactory isisSessionFactory;

    public boolean supportsReloading() {
        return _Context.isPrototyping();
    }

    public BS3MenuBars menuBars() {
        AppManifest appManifest = this.isisSessionFactory.getAppManifest();
        try {
            String xml = _Resources.loadAsString(appManifest.getClass(), (String)menubarsLayoutResourceName, (Charset)StandardCharsets.UTF_8);
            if (_Strings.isEmpty((CharSequence)xml)) {
                if (_Context.isPrototyping()) {
                    this.warnNotFound();
                }
                return null;
            }
            return (BS3MenuBars)this.jaxbService.fromXml(BS3MenuBars.class, xml);
        }
        catch (Exception e) {
            this.severeCannotLoad(e);
            return null;
        }
    }

    private void warnNotFound() {
        if (this.warnedOnce) {
            return;
        }
        AppManifest appManifest = this.isisSessionFactory.getAppManifest();
        log.warn(String.format("Failed to locate resource '%s' at class-path relative to '%s'", menubarsLayoutResourceName, appManifest.getClass().getName()));
        this.warnedOnce = true;
    }

    private void severeCannotLoad(Exception cause) {
        AppManifest appManifest = this.isisSessionFactory.getAppManifest();
        log.error(String.format("Failed to load resource '%s' from class-path relative to '%s'", menubarsLayoutResourceName, appManifest.getClass().getName()), (Throwable)cause);
    }
}

