/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.eventbus;

import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.plugins.eventbus.EventBusPlugin;
import org.apache.isis.core.runtime.services.RequestScopedService;

public abstract class EventBusServiceDefault
extends EventBusService {
    public static final String KEY_ALLOW_LATE_REGISTRATION = "isis.services.eventbus.allowLateRegistration";
    public static final String KEY_EVENT_BUS_IMPLEMENTATION = "isis.services.eventbus.implementation";
    private static final String EVENT_BUS_IMPLEMENTATION_DEFAULT = "plugin";
    private static final String[] KEYWORDS = new String[]{"auto", "plugin", "guava", "axon"};
    protected boolean allowLateRegistration;
    private String implementation;
    @Inject
    ServiceRegistry serviceRegistry;

    public void register(Object domainService) {
        if (!(domainService instanceof RequestScopedService)) {
            if (Annotations.getAnnotation(domainService.getClass(), RequestScoped.class) != null) {
                throw new IllegalArgumentException("Request-scoped services must register their proxy, not themselves");
            }
            if (!this.allowLateRegistration && this.hasPosted()) {
                throw new IllegalStateException("Attempting to register '" + domainService.getClass().getSimpleName() + "' as a subscriber.  However events have already been posted and it is too late to register any further (singleton) subscribers.  Either use @DomainServiceLayout(menuOrder=...) on subscribing services to ensure that subscribers are initialized before any services that might post events, or alternatively use '" + KEY_ALLOW_LATE_REGISTRATION + "' configuration property to relax this check (meaning that some subscribers will miss some posted events)");
            }
        }
        super.register(domainService);
    }

    @Programmatic
    @PostConstruct
    public void init() {
        IsisConfiguration configuration = _Config.getConfiguration();
        this.allowLateRegistration = configuration.getBoolean(KEY_ALLOW_LATE_REGISTRATION, false);
        this.implementation = EventBusServiceDefault.getNormalized(configuration.getString(KEY_EVENT_BUS_IMPLEMENTATION));
    }

    private static String getNormalized(String implementation) {
        if (_Strings.isNullOrEmpty((CharSequence)implementation)) {
            return EVENT_BUS_IMPLEMENTATION_DEFAULT;
        }
        String implementationTrimmed = implementation.trim();
        for (String keyword : KEYWORDS) {
            if (!keyword.equalsIgnoreCase(implementationTrimmed)) continue;
            return keyword;
        }
        return implementationTrimmed;
    }

    boolean isAllowLateRegistration() {
        return this.allowLateRegistration;
    }

    String getImplementation() {
        return this.implementation;
    }

    protected EventBusPlugin newEventBus() {
        EventBusPlugin implementation = this.instantiateEventBus();
        this.serviceRegistry.injectServicesInto((Object)implementation);
        return implementation;
    }

    private EventBusPlugin instantiateEventBus() {
        String fqImplementationName = this.implementation;
        if (EVENT_BUS_IMPLEMENTATION_DEFAULT.equals(this.implementation) || "auto".equals(this.implementation)) {
            return EventBusPlugin.get();
        }
        if ("guava".equals(this.implementation)) {
            fqImplementationName = "org.apache.isis.core.plugins.eventbus.EventBusPluginForGuava";
        } else if ("axon".equals(this.implementation)) {
            fqImplementationName = "org.apache.isis.core.plugins.eventbus.EventBusPluginForAxon";
        }
        Class aClass = ClassUtil.forName((String)fqImplementationName);
        if (EventBusPlugin.class.isAssignableFrom(aClass)) {
            try {
                return (EventBusPlugin)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new NonRecoverableException((Throwable)e);
            }
        }
        throw new NonRecoverableException("Could not instantiate event bus implementation '" + this.implementation + "'");
    }
}

