/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.error;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.services.error.ErrorDetails;
import org.apache.isis.applib.services.error.Ticket;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.runtime.services.error.SimpleTicket;

public class EmailTicket
extends SimpleTicket {
    private static final long serialVersionUID = -748973805361941912L;
    private MailTo mailTo;

    public EmailTicket(MailTo mailTo, String reference, String userMessage, String details, Ticket.StackTracePolicy stackTracePolicy, String kittenUrl) {
        super(reference, userMessage, details, stackTracePolicy, kittenUrl);
        this.mailTo = mailTo;
    }

    @Override
    public String getMarkup() {
        return "<p>" + EmailTicket.ifPresentMap(this.getDetails(), s -> "<h3>" + EmailTicket.htmlEscape(s) + "</h3>") + EmailTicket.ifPresentMap(this.getKittenUrl(), s -> "<img src=\"" + s + "\"></img>") + "</p>" + EmailTicket.ifPresentMap(this.getReference(), s -> "<p><h4>Please report this error: <span>" + this.mailTo.toHtmlLink() + "</span></h4></p>");
    }

    public static class MailTo
    implements Serializable {
        private static final long serialVersionUID = -817872853109724987L;
        private String linkName = "Email";
        private String receiver = "no-one@nowhere";
        private String subject = "[Module-Name] Unexpected Error (#ref)";
        private String body = "empty body";

        public static MailToBuilder builder() {
            return new MailToBuilder();
        }

        public String toHtmlLink() {
            return String.format("<a href=\"mailto:%s?subject=%s&body=%s\">%s</a>", this.receiver, SimpleTicket.htmlEscape(this.subject), SimpleTicket.htmlEscape(this.body), this.linkName);
        }

        public static String mailBodyOf(ErrorDetails errorDetails) {
            return "Stacktrace:%0D%0A=================%0D%0A" + _NullSafe.stream((Collection)errorDetails.getStackTraceDetailPerCause()).map(MailTo::causeToString).collect(Collectors.joining("%0D%0A%0D%0A"));
        }

        private static String causeToString(List<String> list) {
            return "Cause%0D%0A------------%0D%0A" + _NullSafe.stream(list).map(entry -> String.format("# %s", entry)).collect(Collectors.joining("%0D%0A"));
        }

        public static class MailToBuilder {
            private final MailTo mailTo = new MailTo();

            public MailTo build() {
                return this.mailTo;
            }

            public MailToBuilder linkName(String linkName) {
                this.mailTo.linkName = linkName;
                return this;
            }

            public MailToBuilder receiver(String receiver) {
                this.mailTo.receiver = receiver;
                return this;
            }

            public MailToBuilder subject(String subject) {
                this.mailTo.subject = subject;
                return this;
            }

            public MailToBuilder body(String body) {
                this.mailTo.body = body;
                return this;
            }
        }
    }
}

