/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.CommandExecutorService;
import org.apache.isis.applib.services.command.CommandWithDto;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.sudo.SudoService;
import org.apache.isis.applib.services.xactn.Transaction;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.applib.services.xactn.TransactionState;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterLegacy;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.schema.cmd.v1.ActionDto;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.cmd.v1.MemberDto;
import org.apache.isis.schema.cmd.v1.ParamDto;
import org.apache.isis.schema.cmd.v1.ParamsDto;
import org.apache.isis.schema.cmd.v1.PropertyDto;
import org.apache.isis.schema.common.v1.InteractionType;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.OidsDto;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.CommonDtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class CommandExecutorServiceDefault
implements CommandExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutorServiceDefault.class);
    @Inject
    BookmarkService bookmarkService;
    @Inject
    InteractionContext interactionContext;
    @Inject
    SudoService sudoService;
    @Inject
    ClockService clockService;
    @Inject
    TransactionService transactionService;
    @Inject
    CommandContext commandContext;

    @Programmatic
    public void executeCommand(CommandExecutorService.SudoPolicy sudoPolicy, final CommandWithDto commandWithDto) {
        this.ensureTransactionInProgressWithContext((Command)commandWithDto);
        switch (sudoPolicy) {
            case NO_SWITCH: {
                this.executeCommand(commandWithDto);
                break;
            }
            case SWITCH: {
                String user = commandWithDto.getUser();
                this.sudoService.sudo(user, new Runnable(){

                    @Override
                    public void run() {
                        CommandExecutorServiceDefault.this.executeCommand(commandWithDto);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Probable framework error, unrecognized sudoPolicy: " + sudoPolicy);
            }
        }
        this.ensureTransactionInProgress();
    }

    private void ensureTransactionInProgressWithContext(Command command) {
        this.ensureTransactionInProgress();
        if (this.commandContext.getCommand() != command) {
            this.transactionService.nextTransaction(command);
        }
    }

    private void ensureTransactionInProgress() {
        Transaction currentTransaction = this.transactionService.currentTransaction();
        if (currentTransaction == null) {
            throw new IllegalStateException("No current transaction");
        }
        TransactionState transactionState = currentTransaction.getTransactionState();
        if (!transactionState.canCommit()) {
            throw new IllegalStateException("Current transaction is not in a state to be committed, is: " + transactionState);
        }
    }

    protected void executeCommand(CommandWithDto commandWithDto) {
        Interaction interaction = this.interactionContext.getInteraction();
        CommandExecuteIn executeIn = commandWithDto.getExecuteIn();
        LOG.info("Executing: {} {} {} {}", new Object[]{executeIn, commandWithDto.getMemberIdentifier(), commandWithDto.getTimestamp(), commandWithDto.getUniqueId()});
        RuntimeException exceptionIfAny = null;
        try {
            commandWithDto.internal().setExecutor(Command.Executor.BACKGROUND);
            Interaction.Execution currentExecution = interaction.getCurrentExecution();
            Timestamp startedAt = currentExecution != null ? currentExecution.getStartedAt() : this.clockService.nowAsJavaSqlTimestamp();
            commandWithDto.internal().setStartedAt(startedAt);
            CommandDto dto = commandWithDto.asDto();
            MemberDto memberDto = dto.getMember();
            String memberId = memberDto.getMemberIdentifier();
            OidsDto oidsDto = CommandDtoUtils.targetsFor((CommandDto)dto);
            List targetOidDtos = oidsDto.getOid();
            InteractionType interactionType = memberDto.getInteractionType();
            if (interactionType == InteractionType.ACTION_INVOCATION) {
                ActionDto actionDto = (ActionDto)memberDto;
                for (OidDto targetOidDto : targetOidDtos) {
                    ObjectAdapter targetAdapter = this.adapterFor(targetOidDto);
                    ObjectAction objectAction = CommandExecutorServiceDefault.findObjectAction(targetAdapter, memberId);
                    ObjectAdapter[] argAdapters = this.argAdaptersFor(actionDto);
                    ObjectAdapter resultAdapter = objectAction.execute(targetAdapter, null, argAdapters, InteractionInitiatedBy.FRAMEWORK);
                    this.transactionService.flushTransaction();
                    if (resultAdapter == null) continue;
                    Bookmark resultBookmark = CommandUtil.bookmarkFor((ObjectAdapter)resultAdapter);
                    commandWithDto.internal().setResult(resultBookmark);
                }
            } else {
                PropertyDto propertyDto = (PropertyDto)memberDto;
                for (OidDto targetOidDto : targetOidDtos) {
                    Bookmark bookmark = Bookmark.from((OidDto)targetOidDto);
                    Object targetObject = this.bookmarkService.lookup(bookmark, BookmarkService.FieldResetPolicy.RESET);
                    ObjectAdapter targetAdapter = this.adapterFor(targetObject);
                    OneToOneAssociation property = CommandExecutorServiceDefault.findOneToOneAssociation(targetAdapter, memberId);
                    ObjectAdapter newValueAdapter = this.newValueAdapterFor(propertyDto);
                    property.set(targetAdapter, newValueAdapter, InteractionInitiatedBy.FRAMEWORK);
                }
            }
        }
        catch (RuntimeException ex) {
            LOG.warn("Exception when executing : {} {}", new Object[]{executeIn, commandWithDto.getMemberIdentifier(), ex});
            exceptionIfAny = ex;
        }
        try {
            this.transactionService.nextTransaction(TransactionService.Policy.ALWAYS);
        }
        catch (RuntimeException ex) {
            LOG.warn("Exception when committing : {} {}", new Object[]{executeIn, commandWithDto.getMemberIdentifier(), ex});
            if (exceptionIfAny == null) {
                exceptionIfAny = ex;
            }
            this.transactionService.nextTransaction();
        }
        Interaction.Execution priorExecution = interaction.getPriorExecution();
        if (commandWithDto.getStartedAt() == null) {
            commandWithDto.internal().setStartedAt(priorExecution != null ? priorExecution.getStartedAt() : this.clockService.nowAsJavaSqlTimestamp());
        }
        Timestamp completedAt = priorExecution != null ? priorExecution.getCompletedAt() : this.clockService.nowAsJavaSqlTimestamp();
        commandWithDto.internal().setCompletedAt(completedAt);
        if (exceptionIfAny != null) {
            commandWithDto.internal().setException(_Exceptions.streamStacktraceLines((Throwable)exceptionIfAny, (int)500).collect(Collectors.joining("\n")));
        }
    }

    private static ObjectAction findObjectAction(ObjectAdapter targetAdapter, String actionId) throws RuntimeException {
        ObjectSpecification specification = targetAdapter.getSpecification();
        ObjectAction objectAction = CommandExecutorServiceDefault.findActionElseNull(specification, actionId);
        if (objectAction == null) {
            throw new RuntimeException(String.format("Unknown action '%s'", actionId));
        }
        return objectAction;
    }

    private static OneToOneAssociation findOneToOneAssociation(ObjectAdapter targetAdapter, String propertyId) throws RuntimeException {
        ObjectSpecification specification = targetAdapter.getSpecification();
        OneToOneAssociation property = CommandExecutorServiceDefault.findOneToOneAssociationElseNull(specification, propertyId);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s'", propertyId));
        }
        return property;
    }

    private ObjectAdapter newValueAdapterFor(PropertyDto propertyDto) {
        ValueWithTypeDto newValue = propertyDto.getNewValue();
        Object arg = CommonDtoUtils.getValue((ValueWithTypeDto)newValue);
        return this.adapterFor(arg);
    }

    private static ObjectAction findActionElseNull(ObjectSpecification specification, String actionId) {
        Stream objectActions = specification.streamObjectActions(Contributed.INCLUDED);
        return objectActions.filter(objectAction -> objectAction.getIdentifier().toClassAndNameIdentityString().equals(actionId)).findAny().orElse(null);
    }

    private static OneToOneAssociation findOneToOneAssociationElseNull(ObjectSpecification specification, String propertyId) {
        Stream associations = specification.streamAssociations(Contributed.INCLUDED);
        return associations.filter(association -> association.getIdentifier().toClassAndNameIdentityString().equals(propertyId) && association instanceof OneToOneAssociation).findAny().map(association -> (OneToOneAssociation)association).orElse(null);
    }

    private ObjectAdapter[] argAdaptersFor(ActionDto actionDto) {
        List<ParamDto> params = CommandExecutorServiceDefault.paramDtosFrom(actionDto);
        ArrayList args = _Lists.newArrayList((Collection)params.stream().map(paramDto -> {
            Object arg = CommonDtoUtils.getValue((ParamDto)paramDto);
            return this.adapterFor(arg);
        }).collect(Collectors.toList()));
        return args.toArray(new ObjectAdapter[0]);
    }

    private static List<ParamDto> paramDtosFrom(ActionDto actionDto) {
        List parameterList;
        ParamsDto parameters = actionDto.getParameters();
        if (parameters != null && (parameterList = parameters.getParameter()) != null) {
            return parameterList;
        }
        return Collections.emptyList();
    }

    private ObjectAdapter adapterFor(Object targetObject) {
        return ObjectAdapterLegacy.__CommandExecutorServiceDefault.adapterFor(targetObject);
    }

    protected IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.getIsisSessionFactory().getCurrentSession().getPersistenceSession();
    }

    protected IsisTransactionManager getTransactionManager(PersistenceSession persistenceSession) {
        return persistenceSession.getTransactionManager();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.getIsisSessionFactory().getSpecificationLoader();
    }
}

