/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandExecutorService;
import org.apache.isis.applib.services.command.CommandWithDto;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.runtime.services.background.CommandExecutionAbstract;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundCommandExecution
extends CommandExecutionAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundCommandExecution.class);

    public BackgroundCommandExecution() {
        this(CommandExecutorService.SudoPolicy.NO_SWITCH);
    }

    public BackgroundCommandExecution(CommandExecutorService.SudoPolicy sudoPolicy) {
        super(sudoPolicy);
    }

    @Override
    protected void doExecute(Object context) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        IsisTransactionManager transactionManager = this.getTransactionManager(persistenceSession);
        ArrayList commands = _Lists.newArrayList();
        transactionManager.executeWithinTransaction(() -> commands.addAll(this.findBackgroundCommandsToExecute()));
        LOG.debug("Found {} to execute", (Object)commands.size());
        for (Command command : commands) {
            this.execute(transactionManager, (CommandWithDto)command);
        }
    }

    protected abstract List<? extends Command> findBackgroundCommandsToExecute();
}

