/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerAbstract;
import org.apache.isis.core.runtime.services.ServicesInstallerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesInstallerFromConfiguration
extends ServicesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(ServicesInstallerFromConfiguration.class);
    public static final String NAME = "configuration";
    private static final String SERVICES = "services";
    public static final String SERVICES_KEY = "isis.services";
    private static final Pattern POSITIONED_SERVICE_REGEX = Pattern.compile("((\\d+):)(.*)");
    private final ServiceInstantiator serviceInstantiator;
    private List<Object> serviceList;

    public ServicesInstallerFromConfiguration() {
        this(new ServiceInstantiator());
    }

    ServicesInstallerFromConfiguration(ServiceInstantiator serviceInstantiator) {
        super(NAME);
        this.serviceInstantiator = serviceInstantiator;
    }

    @Override
    public void init() {
    }

    @Override
    public List<Object> getServices() {
        LOG.info("installing {}", (Object)this.getClass().getName());
        if (this.serviceList == null) {
            TreeMap positionedServices = _Maps.newTreeMap((Comparator)new DeweyOrderComparator());
            this.appendServices(positionedServices);
            this.serviceList = ServicesInstallerUtils.instantiateServicesFrom(positionedServices, this.serviceInstantiator);
        }
        return this.serviceList;
    }

    void appendServices(SortedMap<String, SortedSet<String>> positionedServices) {
        this.appendConfiguredServices(positionedServices);
    }

    private void appendConfiguredServices(SortedMap<String, SortedSet<String>> positionedServices) {
        String configuredServices = _Config.getConfiguration().getString(SERVICES_KEY);
        if (configuredServices == null) {
            return;
        }
        StringTokenizer services = new StringTokenizer(configuredServices, ",");
        while (services.hasMoreTokens()) {
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            Matcher matcher = POSITIONED_SERVICE_REGEX.matcher(serviceName);
            Integer order = Integer.MAX_VALUE;
            if (matcher.matches()) {
                order = Integer.parseInt(matcher.group(2));
                serviceName = matcher.group(3);
            }
            ServicesInstallerUtils.appendInPosition(positionedServices, "" + order, serviceName);
        }
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromConfiguration.listOf((Class[])new Class[]{List.class});
    }
}

