/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceMenuOrder;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;
import org.apache.isis.core.runtime.services.ServiceInstantiator;
import org.apache.isis.core.runtime.services.ServicesInstallerAbstract;
import org.apache.isis.core.runtime.services.ServicesInstallerUtils;

public class ServicesInstallerFromAnnotation
extends ServicesInstallerAbstract {
    public static final String NAME = "annotation";
    private final ServiceInstantiator serviceInstantiator;
    private List<Object> services;

    public ServicesInstallerFromAnnotation() {
        this(new ServiceInstantiator());
    }

    public ServicesInstallerFromAnnotation(ServiceInstantiator serviceInstantiator) {
        super(NAME);
        this.serviceInstantiator = serviceInstantiator;
    }

    @Override
    public void init() {
    }

    @PreDestroy
    public void shutdown() {
    }

    private Predicate<Class<?>> instantiatable() {
        return input -> input != null && !Modifier.isAbstract(input.getModifiers());
    }

    @Override
    public List<Object> getServices() {
        if (this.services == null) {
            TreeMap positionedServices = _Maps.newTreeMap((Comparator)new DeweyOrderComparator());
            this.appendServices(positionedServices);
            this.services = ServicesInstallerUtils.instantiateServicesFrom(positionedServices, this.serviceInstantiator);
        }
        return this.services;
    }

    public void appendServices(SortedMap<String, SortedSet<String>> positionedServices) {
        Set domainServiceTypes = AppManifest.Registry.instance().getDomainServiceTypes();
        _With.requires((Object)domainServiceTypes, (String)"domainServiceTypes");
        List domainServiceClasses = _Lists.filter((Collection)domainServiceTypes, this.instantiatable());
        for (Class cls : domainServiceClasses) {
            String order = DomainServiceMenuOrder.orderOf((Class)cls);
            String fullyQualifiedClassName = cls.getName();
            ServicesInstallerUtils.appendInPosition(positionedServices, order, fullyQualifiedClassName);
        }
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromAnnotation.listOf((Class[])new Class[]{List.class});
    }

    public static abstract class ActionDomainEvent
    extends org.apache.isis.applib.events.domain.ActionDomainEvent<ServicesInstallerFromAnnotation> {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class CollectionDomainEvent<T>
    extends org.apache.isis.applib.events.domain.CollectionDomainEvent<ServicesInstallerFromAnnotation, T> {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class PropertyDomainEvent<T>
    extends org.apache.isis.applib.events.domain.PropertyDomainEvent<ServicesInstallerFromAnnotation, T> {
        private static final long serialVersionUID = 1L;
    }
}

