/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.isis.core.runtime.headless.logging.LeveledLogger;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class LogStream
extends OutputStream {
    private final LeveledLogger logger;
    private final StringBuilder buf = new StringBuilder();

    public static PrintStream logPrintStream(Logger logger, Level level) {
        return new PrintStream(new LogStream(logger, level));
    }

    public LogStream(Logger logger, Level level) {
        this.logger = new LeveledLogger(logger, level);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        this.logger.log(this.toString());
        this.buf.delete(0, this.buf.length());
    }

    @Override
    public void write(byte[] b) {
        String str = new String(b);
        this.buf.append(str);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String str = new String(b, off, len);
        this.buf.append(str);
    }

    @Override
    public void write(int codePoint) {
        char[] chars = Character.toChars(codePoint);
        this.buf.append(chars);
    }

    public String toString() {
        return this.buf.toString();
    }
}

