/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import java.util.List;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.fixtures.TickingFixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.runtime.headless.IsisSystem;
import org.apache.isis.core.runtime.headless.logging.LeveledLogger;
import org.apache.isis.core.runtime.headless.logging.LogConfig;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSystemBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSystemBootstrapper.class);
    private static ThreadLocal<AppManifest> isftAppManifest = new ThreadLocal();
    private final IsisConfiguration isisConfiguration;
    private final LeveledLogger logger;

    public static IsisSystemBootstrapper of(LogConfig logConfig, IsisConfiguration isisConfiguration) {
        return new IsisSystemBootstrapper(logConfig, isisConfiguration);
    }

    private IsisSystemBootstrapper(LogConfig logConfig, IsisConfiguration isisConfiguration) {
        Ensure.ensure((String)"Should have an IsisConfiguration!", (isisConfiguration != null ? 1 : 0) != 0);
        Ensure.ensure((String)"Should have an AppManifest!", (isisConfiguration.getAppManifest() != null ? 1 : 0) != 0);
        this.isisConfiguration = isisConfiguration;
        this.logger = new LeveledLogger(LOG, logConfig.getTestLoggingLevel());
    }

    public IsisSystem bootstrapIfRequired() {
        this.bootstrapUsingConfig();
        return IsisSystem.get();
    }

    public void setupModuleRefData() {
        MetaModelService metaModelService = IsisSystemBootstrapper.lookupService(MetaModelService.class);
        FixtureScript refDataSetupFixture = metaModelService.getAppManifest2().getRefDataSetupFixture();
        this.runFixtureScript(refDataSetupFixture);
    }

    private void bootstrapUsingConfig() {
        SystemState systemState = IsisSystemBootstrapper.determineSystemState(this.isisConfiguration.getAppManifest());
        switch (systemState) {
            case BOOTSTRAPPED_SAME_MODULES: {
                break;
            }
            case BOOTSTRAPPED_DIFFERENT_MODULES: {
                throw new RuntimeException("Bootstrapping different modules is not yet supported");
            }
            case NOT_BOOTSTRAPPED: {
                long t0 = System.currentTimeMillis();
                IsisSystemBootstrapper.setupSystem(this.isisConfiguration);
                long t1 = System.currentTimeMillis();
                this.log("##########################################################################");
                this.log("# Bootstrapped in " + (t1 - t0) + " millis");
                this.log("##########################################################################");
                TickingFixtureClock.replaceExisting();
            }
        }
    }

    private static SystemState determineSystemState(AppManifest appManifest) {
        IsisSystem isft = IsisSystem.getElseNull();
        if (isft == null) {
            return SystemState.NOT_BOOTSTRAPPED;
        }
        AppManifest appManifestFromPreviously = isftAppManifest.get();
        return IsisSystemBootstrapper.haveSameModules(appManifest, appManifestFromPreviously) ? SystemState.BOOTSTRAPPED_SAME_MODULES : SystemState.BOOTSTRAPPED_DIFFERENT_MODULES;
    }

    static boolean haveSameModules(AppManifest m1, AppManifest m2) {
        List m2Modules;
        List m1Modules = m1.getModules();
        return m1Modules.containsAll(m2Modules = m2.getModules()) && m2Modules.containsAll(m1Modules);
    }

    private static IsisSystem setupSystem(IsisConfiguration isisConfiguration) {
        IsisSystem isft = IsisSystem.ofConfiguration(isisConfiguration);
        isft.setUpSystem();
        IsisSystem.set(isft);
        isftAppManifest.set(isisConfiguration.getAppManifest());
        return isft;
    }

    public void injectServicesInto(Object object) {
        IsisSystemBootstrapper.lookupService(ServiceRegistry.class).injectServicesInto(object);
    }

    private static void teardownSystem() {
        IsisSessionFactory isisSessionFactory = IsisSystemBootstrapper.lookupService(IsisSessionFactory.class);
        IsisJdoSupport isisJdoSupport = IsisSystemBootstrapper.lookupService(IsisJdoSupport.class);
        PersistenceManagerFactory pmf = isisJdoSupport.getJdoPersistenceManager().getPersistenceManagerFactory();
        isisSessionFactory.destroyServicesAndShutdown();
        pmf.close();
        IsisContext.clear();
    }

    public void tearDownAllModules() {
        MetaModelService metaModelService4 = IsisSystemBootstrapper.lookupService(MetaModelService.class);
        FixtureScript fixtureScript = metaModelService4.getAppManifest2().getTeardownFixture();
        this.runFixtureScript(fixtureScript);
    }

    private void runFixtureScript(FixtureScript ... fixtureScriptList) {
        FixtureScripts fixtureScripts = IsisSystemBootstrapper.lookupService(FixtureScripts.class);
        fixtureScripts.runFixtureScript(fixtureScriptList);
    }

    private static IsisSystem getIsisSystem() {
        return IsisSystem.get();
    }

    private static <T> T lookupService(Class<T> serviceClass) {
        return IsisSystemBootstrapper.getIsisSystem().getService(serviceClass);
    }

    private void log(String message) {
        this.logger.log(message);
    }

    static enum SystemState {
        NOT_BOOTSTRAPPED,
        BOOTSTRAPPED_SAME_MODULES,
        BOOTSTRAPPED_DIFFERENT_MODULES;

    }
}

