/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.headless.auth.AuthenticationRequestNameOnly;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.security.authentication.AuthenticationRequest;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;

public final class IsisSystem {
    protected static ThreadLocal<IsisSystem> ISFT = new ThreadLocal();
    protected final AppManifest appManifest;
    protected final AuthenticationRequest authenticationRequestIfAny;
    protected AuthenticationSession authenticationSession;
    protected IsisSessionFactory isisSessionFactory;

    public static IsisSystem getElseNull() {
        return ISFT.get();
    }

    public static IsisSystem get() {
        IsisSystem isft = ISFT.get();
        if (isft == null) {
            throw new IllegalStateException("No IsisSystem available on thread; call #set(IsisSystem) first");
        }
        return isft;
    }

    public static void set(IsisSystem isft) {
        ISFT.set(isft);
    }

    public static IsisSystem ofConfiguration(IsisConfiguration isisConfiguration) {
        AppManifest appManifest = isisConfiguration.getAppManifest();
        AuthenticationRequestNameOnly authenticationRequest = new AuthenticationRequestNameOnly("tester");
        return new IsisSystem(appManifest, (AuthenticationRequest)authenticationRequest);
    }

    private IsisSystem(AppManifest appManifest, AuthenticationRequest authenticationRequestIfAny) {
        this.appManifest = appManifest;
        this.authenticationRequestIfAny = authenticationRequestIfAny;
    }

    IsisSystem setUpSystem() throws RuntimeException {
        try {
            this.initIfRequiredThenOpenSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void initIfRequiredThenOpenSession() throws Exception {
        boolean firstTime;
        MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
        if (mmie != null) {
            Set validationErrors = mmie.getValidationErrors();
            String validationMsg = _NullSafe.stream((Collection)validationErrors).collect(Collectors.joining("\n"));
            throw new AssertionError((Object)validationMsg);
        }
        boolean bl = firstTime = this.isisSessionFactory == null;
        if (firstTime) {
            IsisComponentProvider componentProvider = IsisComponentProvider.builder(this.appManifest).build();
            IsisSessionFactoryBuilder isisSessionFactoryBuilder = new IsisSessionFactoryBuilder(componentProvider);
            FixtureClock.initialize();
            this.isisSessionFactory = isisSessionFactoryBuilder.buildSessionFactory();
            this.closeSession();
            MetaModelInvalidException ex = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (ex != null) {
                IsisContext.clear();
                Set validationErrors = ex.getValidationErrors();
                StringBuilder buf = new StringBuilder();
                for (String validationError : validationErrors) {
                    buf.append(validationError).append("\n");
                }
                throw new AssertionError((Object)("Metamodel is invalid: \n" + buf.toString()));
            }
        }
        AuthenticationManager authenticationManager = this.isisSessionFactory.getAuthenticationManager();
        this.authenticationSession = authenticationManager.authenticate(this.authenticationRequestIfAny);
        this.openSession();
    }

    public IsisSessionFactory getIsisSessionFactory() {
        return this.isisSessionFactory;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void nextSession() throws Exception {
        this.closeSession();
        this.openSession();
    }

    public void openSession() throws Exception {
        this.openSession(this.authenticationSession);
    }

    public void openSession(AuthenticationSession authenticationSession) throws Exception {
        this.isisSessionFactory.openSession(authenticationSession);
    }

    public void closeSession() throws Exception {
        if (this.isisSessionFactory != null && this.isisSessionFactory.inSession()) {
            this.isisSessionFactory.closeSession();
        }
    }

    public <C> C getService(Class<C> serviceClass) {
        ServicesInjector servicesInjector = this.isisSessionFactory.getServicesInjector();
        return (C)servicesInjector.lookupServiceElseFail(serviceClass);
    }
}

