/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.plugins.classdiscovery.reflections;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;

class ReflectManifest {
    private static final List<Vfs.UrlType> urlTypes = new ArrayList<Vfs.UrlType>();

    ReflectManifest() {
    }

    public static void prepareDiscovery() {
        Vfs.setDefaultURLTypes(ReflectManifest.getUrlTypes());
    }

    private static List<Vfs.UrlType> getUrlTypes() {
        if (urlTypes.isEmpty()) {
            urlTypes.add(new EmptyIfFileEndingsUrlType(new String[]{".pom", ".jnilib", "QTJava.zip"}));
            urlTypes.add(new JettyConsoleUrlType());
            urlTypes.addAll(Arrays.asList(Vfs.DefaultUrlTypes.values()));
        }
        return urlTypes;
    }

    private static class JettyConsoleUrlType
    implements Vfs.UrlType {
        private JettyConsoleUrlType() {
        }

        public boolean matches(URL url) {
            String protocol = url.getProtocol();
            String externalForm = url.toExternalForm();
            boolean matches = protocol.equals("file") && externalForm.contains("jetty-console") && externalForm.contains("-any-") && externalForm.endsWith("webapp/WEB-INF/classes/");
            return matches;
        }

        public Vfs.Dir createDir(URL url) throws Exception {
            return new SystemDir(JettyConsoleUrlType.getFile(url));
        }

        static File getFile(URL url) {
            File file;
            String path;
            try {
                path = url.toURI().getSchemeSpecificPart();
                file = new File(path);
                if (file.exists()) {
                    return file;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            try {
                path = URLDecoder.decode(url.getPath(), "UTF-8");
                if (path.contains(".jar!")) {
                    path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
                }
                if ((file = new File(path)).exists()) {
                    return file;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                path = url.toExternalForm();
                if (path.startsWith("jar:")) {
                    path = path.substring("jar:".length());
                }
                if (path.startsWith("file:")) {
                    path = path.substring("file:".length());
                }
                if (path.contains(".jar!")) {
                    path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
                }
                if ((file = new File(path)).exists()) {
                    return file;
                }
                file = new File(path = path.replace("%20", " "));
                if (file.exists()) {
                    return file;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static class EmptyIfFileEndingsUrlType
    implements Vfs.UrlType {
        private final List<String> fileEndings;

        private EmptyIfFileEndingsUrlType(String ... fileEndings) {
            this.fileEndings = Arrays.asList(fileEndings);
        }

        public boolean matches(URL url) {
            String protocol = url.getProtocol();
            String externalForm = url.toExternalForm();
            if (!protocol.equals("file")) {
                return false;
            }
            for (String fileEnding : this.fileEndings) {
                if (!externalForm.endsWith(fileEnding)) continue;
                return true;
            }
            return false;
        }

        public Vfs.Dir createDir(URL url) throws Exception {
            return EmptyIfFileEndingsUrlType.emptyVfsDir(url);
        }

        private static Vfs.Dir emptyVfsDir(final URL url) {
            return new Vfs.Dir(){

                public String getPath() {
                    return url.toExternalForm();
                }

                public Iterable<Vfs.File> getFiles() {
                    return Collections.emptyList();
                }

                public void close() {
                }
            };
        }
    }
}

