/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.query;

import java.util.List;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryFacet;

abstract class VisitorForClauseAbstract
implements MetaModelValidatorVisiting.Visitor {
    private final JdoQueryAnnotationFacetFactory facetFactory;
    final String clause;

    VisitorForClauseAbstract(JdoQueryAnnotationFacetFactory facetFactory, String clause) {
        this.facetFactory = facetFactory;
        this.clause = clause;
    }

    @Override
    public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
        this.validate(objectSpec, validationFailures);
        return true;
    }

    private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
        JdoQueryFacet facet = objectSpec.getFacet(JdoQueryFacet.class);
        if (facet == null) {
            return;
        }
        List<JdoNamedQuery> namedQueries = facet.getNamedQueries();
        for (JdoNamedQuery namedQuery : namedQueries) {
            if (!namedQuery.getLanguage().equals("JDOQL")) continue;
            String query = namedQuery.getQuery();
            String fromClassName = this.deriveClause(query);
            this.interpretJdoql(fromClassName, objectSpec, query, validationFailures);
        }
    }

    private void interpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query, ValidationFailures validationFailures) {
        if (classNameFromClause == null) {
            return;
        }
        String className = objectSpec.getCorrespondingClass().getName();
        if (!this.getSpecificationLoader().loaded(classNameFromClause)) {
            validationFailures.add("%s: error in JDOQL query, class name for '%s' clause not recognized (JDOQL : %s)", className, this.clause, query);
            return;
        }
        this.postInterpretJdoql(classNameFromClause, objectSpec, query, validationFailures);
    }

    abstract String deriveClause(String var1);

    abstract void postInterpretJdoql(String var1, ObjectSpecification var2, String var3, ValidationFailures var4);

    SpecificationLoader getSpecificationLoader() {
        return this.facetFactory.getSpecificationLoader();
    }
}

