/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable;

import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.ObjectSpecIdFacetFactory;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacetAnnotation;

public class JdoPersistenceCapableAnnotationFacetFactory
extends FacetFactoryAbstract
implements ObjectSpecIdFacetFactory {
    public JdoPersistenceCapableAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(ObjectSpecIdFacetFactory.ProcessObjectSpecIdContext processClassContext) {
        String annotationTableAttribute;
        Class<?> cls = processClassContext.getCls();
        if (!JdoMetamodelUtil.isPersistenceEnhanced(cls)) {
            return;
        }
        PersistenceCapable annotation = Annotations.getAnnotation(cls, PersistenceCapable.class);
        if (annotation == null) {
            return;
        }
        String annotationSchemaAttribute = annotation.schema();
        if (_Strings.isNullOrEmpty((CharSequence)annotationSchemaAttribute)) {
            annotationSchemaAttribute = null;
        }
        if (_Strings.isNullOrEmpty((CharSequence)(annotationTableAttribute = annotation.table()))) {
            annotationTableAttribute = cls.getSimpleName();
        }
        IdentityType annotationIdentityType = annotation.identityType();
        FacetUtil.addFacet(new JdoPersistenceCapableFacetAnnotation(annotationSchemaAttribute, annotationTableAttribute, annotationIdentityType, (FacetHolder)processClassContext.getFacetHolder()));
    }
}

