/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.commons.lang.InputStreamExtensions;
import org.apache.isis.core.commons.lang.ResourceUtil;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.webapp.content.ResourceServlet_HtmlTemplateVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private static final long serialVersionUID = 1L;
    private ResourceServlet_HtmlTemplateVariables templateVariables;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String restfulPath = (String)_With.ifPresentElse((Object)_Resources.getRestfulPathIfAny(), (Object)"restful");
        String restfulBase = _Resources.prependContextPathIfPresent((String)restfulPath);
        this.templateVariables = new ResourceServlet_HtmlTemplateVariables(_Strings.pair((String)"restful-base", (String)_Strings.prefix((String)restfulBase, (String)"/")));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = StringExtensions.stripLeadingSlash(request.getServletPath());
        LOG.debug("request: {}", (Object)servletPath);
        InputStream is = (InputStream)_With.ifPresentElseGet((Object)ResourceUtil.getResourceAsStream(request), () -> ResourceUtil.getResourceAsStream(servletPath));
        if (is != null) {
            LOG.debug("request: {} loaded from classpath", (Object)servletPath);
            try {
                ResourceServlet.writeContentType(request, response);
                this.processContent(is, request, response);
                return;
            }
            finally {
                is.close();
            }
        }
        LOG.warn("failed to load resource from classpath or file system: {}", (Object)servletPath);
    }

    private void processContent(InputStream is, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getServletPath().endsWith(".template.html")) {
            String templateContent = _Strings.ofBytes((byte[])_Bytes.of((InputStream)is), (Charset)StandardCharsets.UTF_8);
            String htmlContent = this.templateVariables.applyTo(templateContent);
            response.getWriter().append(htmlContent);
        } else {
            InputStreamExtensions.copyTo(is, (OutputStream)response.getOutputStream());
        }
    }

    private static void writeContentType(HttpServletRequest request, HttpServletResponse response) {
        String contentType = ResourceServlet.guessContentType(request.getServletPath());
        if (contentType != null) {
            response.setContentType(contentType);
        }
    }

    private static String guessContentType(String servletPath) {
        if (servletPath.endsWith(".css")) {
            return "text/css";
        }
        if (servletPath.endsWith(".png")) {
            return "image/png";
        }
        if (servletPath.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (servletPath.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (servletPath.endsWith(".gif")) {
            return "image/gif";
        }
        if (servletPath.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (servletPath.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (servletPath.endsWith(".html")) {
            return "text/html";
        }
        if (servletPath.endsWith(".swf")) {
            return "application/x-shockwave-flash";
        }
        return null;
    }
}

