/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.threadpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.runtime.threadpool.FutureWithIndexIntoFutureOfList;
import org.apache.isis.core.runtime.threadpool.ThreadPoolExecutionMode;
import org.apache.isis.core.runtime.threadpool.ThreadPoolSizeAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolSupport
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolSupport.class);
    public static ThreadPoolExecutionMode HIGHEST_CONCURRENCY_EXECUTION_MODE_ALLOWED = ThreadPoolExecutionMode.PARALLEL;
    private static final int KEEP_ALIVE_TIME_SECS = 5;
    private static final int QUEUE_CAPACITY = Integer.MAX_VALUE;
    private final ThreadGroup group = new ThreadGroup(ThreadPoolSupport.class.getName());
    private final ThreadPoolExecutor concurrentExecutor;

    public static ThreadPoolSupport getInstance() {
        return (ThreadPoolSupport)_Context.computeIfAbsent(ThreadPoolSupport.class, __ -> new ThreadPoolSupport());
    }

    ThreadPoolSupport() {
        ThreadPoolSizeAdvisor advisor = ThreadPoolSizeAdvisor.get();
        ThreadFactory threadFactory = r -> new Thread(this.group, r);
        Supplier<BlockingQueue> workQueueFactory = () -> new LinkedBlockingQueue(Integer.MAX_VALUE);
        this.concurrentExecutor = new ThreadPoolExecutor(advisor.corePoolSize(), advisor.maximumPoolSize(), 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)workQueueFactory.get(), threadFactory);
    }

    @Override
    public void close() throws Exception {
        this.concurrentExecutor.shutdown();
    }

    public Executor getExecutor() {
        return this.concurrentExecutor;
    }

    public <T> CompletableFuture<T> newCompletableFuture(Supplier<T> computation) {
        _With.requires(computation, (String)"computation");
        return CompletableFuture.supplyAsync(computation, this.getExecutor());
    }

    public List<Future<Object>> invokeAll(ThreadPoolExecutionMode proposedExecutionMode, @Nullable List<Callable<Object>> callables) {
        if (ThreadPoolSupport.isEmpty(callables)) {
            return Collections.emptyList();
        }
        _With.requires((Object)((Object)proposedExecutionMode), (String)"proposedExecutionMode");
        ThreadPoolExecutionMode executionMode = ThreadPoolExecutionMode.honorHighestConcurrencyAllowed(proposedExecutionMode);
        switch (executionMode) {
            case PARALLEL: {
                return this.invokeAll(this.concurrentExecutor, callables);
            }
            case SEQUENTIAL: {
                Future commonFuture = (Future)_Casts.uncheckedCast(this.invokeAll(this.concurrentExecutor, Collections.singletonList(this.toSingleTask(callables))).get(0));
                return IntStream.range(0, callables.size()).mapToObj(index -> new FutureWithIndexIntoFutureOfList(commonFuture, index)).collect(Collectors.toList());
            }
            case SEQUENTIAL_WITHIN_CALLING_THREAD: {
                return callables.stream().map(FutureTask::new).peek(FutureTask::run).collect(Collectors.toList());
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)HIGHEST_CONCURRENCY_EXECUTION_MODE_ALLOWED));
    }

    public List<Future<Object>> invokeAll(@Nullable List<Callable<Object>> callables) {
        return this.invokeAll(HIGHEST_CONCURRENCY_EXECUTION_MODE_ALLOWED, callables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> join(@Nullable List<Future<Object>> futures) {
        if (futures == null) {
            return null;
        }
        long t0 = System.nanoTime();
        try {
            ArrayList returnValues = _Lists.newArrayList();
            for (Future<Object> future : futures) {
                returnValues.add(this.join(future));
            }
            ArrayList arrayList = returnValues;
            return arrayList;
        }
        finally {
            long t1 = System.nanoTime();
            LOG.info("join'ing {} tasks: waited {} milliseconds ", (Object)futures.size(), (Object)(1.0E-6 * (double)(t1 - t0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> joinGatherFailures(List<Future<Object>> futures) {
        if (futures == null) {
            return null;
        }
        long t0 = System.nanoTime();
        try {
            ArrayList returnValues = _Lists.newArrayList();
            for (Future<Object> future : futures) {
                Object result;
                try {
                    result = future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                returnValues.add(result);
            }
            ArrayList arrayList = returnValues;
            return arrayList;
        }
        finally {
            long t1 = System.nanoTime();
            LOG.info("join'ing {} tasks: waited {} milliseconds ", (Object)futures.size(), (Object)(1.0E-6 * (double)(t1 - t0)));
        }
    }

    public Object join(Future<Object> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    public String toString() {
        return this.concurrentExecutor.toString();
    }

    private List<Future<Object>> invokeAll(ThreadPoolExecutor executor, @Nullable List<Callable<Object>> callables) {
        if (ThreadPoolSupport.isEmpty(callables)) {
            return Collections.emptyList();
        }
        try {
            return executor.invokeAll(ThreadPoolSupport.timed(executor, callables));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Callable<Object>> timed(ThreadPoolExecutor executor, List<Callable<Object>> callables) {
        long queuedAt = System.currentTimeMillis();
        return callables.stream().map(callable -> ThreadPoolSupport.timed(callable, executor.getQueue().size(), queuedAt)).collect(Collectors.toList());
    }

    private static Callable<Object> timed(Callable<Object> callable, int queueSize, long queuedAt) {
        return () -> {
            long startedAt = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("START: workQueue.size: {}, waited for: {}ms, {}", new Object[]{queueSize, startedAt - queuedAt, callable.toString()});
            }
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                long completedAt = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("END: completed in: {}ms, {}", (Object)(completedAt - startedAt), (Object)callable.toString());
                }
            }
        };
    }

    private Callable<Object> toSingleTask(List<Callable<Object>> callables) {
        return () -> {
            ArrayList resultList = _Lists.newArrayList();
            for (Callable callable : callables) {
                resultList.add(callable.call());
            }
            return resultList;
        };
    }

    private static boolean isEmpty(Collection<?> x) {
        return x == null || x.size() == 0;
    }
}

