/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorAbstract;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class MetaModelValidatorVisiting
extends MetaModelValidatorAbstract {
    private final Visitor visitor;

    public MetaModelValidatorVisiting(Visitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public final void validate(ValidationFailures validationFailures) {
        this.validateAll(validationFailures);
        this.summarize(validationFailures);
    }

    private void validateAll(ValidationFailures validationFailures) {
        ArrayList specsValidated = _Lists.newArrayList();
        while (this.validateSpecs(specsValidated, validationFailures)) {
        }
    }

    private boolean validateSpecs(List<ObjectSpecification> specsAlreadyValidated, ValidationFailures validationFailures) {
        ObjectSpecification objSpec;
        List<ObjectSpecification> specsToValidate = this.specificationLoader.allSpecifications();
        specsToValidate.removeAll(specsAlreadyValidated);
        if (specsToValidate.isEmpty()) {
            return false;
        }
        Iterator iterator = specsToValidate.iterator();
        while (iterator.hasNext() && this.visitor.visit(objSpec = (ObjectSpecification)iterator.next(), validationFailures)) {
        }
        specsAlreadyValidated.addAll(specsToValidate);
        return true;
    }

    private void summarize(ValidationFailures validationFailures) {
        if (this.visitor instanceof SummarizingVisitor) {
            SummarizingVisitor summarizingVisitor = (SummarizingVisitor)this.visitor;
            summarizingVisitor.summarize(validationFailures);
        }
    }

    public static interface SummarizingVisitor
    extends Visitor {
        public void summarize(ValidationFailures var1);
    }

    public static interface Visitor {
        public boolean visit(ObjectSpecification var1, ValidationFailures var2);
    }
}

