/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetHolderImpl;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacetInferred;
import org.apache.isis.core.metamodel.interactions.ActionValidityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.MixedInMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterMixedInAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyActionParameterMixedIn;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterMixedIn;

public class ObjectActionMixedIn
extends ObjectActionDefault
implements MixedInMember {
    private final Class<?> mixinType;
    final ObjectActionDefault mixinAction;
    private final ObjectSpecification mixedInType;
    private final FacetHolder facetHolder = new FacetHolderImpl();
    private List<ObjectActionParameter> parameters;
    private final Identifier identifier;

    public ObjectActionMixedIn(Class<?> mixinType, String mixinMethodName, ObjectActionDefault mixinAction, ObjectSpecification mixedInType, ServicesInjector objectMemberDependencies) {
        super(mixinAction.getFacetedMethod(), objectMemberDependencies);
        this.mixinType = mixinType;
        this.mixinAction = mixinAction;
        this.mixedInType = mixedInType;
        FacetUtil.copyFacets(mixinAction.getFacetedMethod(), this.facetHolder);
        String name = this.getName();
        if (_Strings.isNullOrEmpty((CharSequence)name) || name.equalsIgnoreCase(mixinMethodName)) {
            String memberName = ObjectActionMixedIn.determineNameFrom(mixinAction);
            FacetUtil.addFacet(new NamedFacetInferred(memberName, this.facetHolder));
        }
        Identifier mixinIdentifier = mixinAction.getFacetedMethod().getIdentifier();
        List memberParameterNames = mixinIdentifier.getMemberParameterNames();
        this.identifier = Identifier.actionIdentifier((String)this.getOnType().getCorrespondingClass().getName(), (String)this.getId(), (List)memberParameterNames);
    }

    @Override
    public String getId() {
        return ObjectActionMixedIn.determineIdFrom(this.mixinAction);
    }

    @Override
    public String getOriginalId() {
        return super.getId();
    }

    public boolean hasMixinAction(ObjectAction mixinAction) {
        return this.mixinAction == mixinAction;
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.mixedInType;
    }

    @Override
    public int getParameterCount() {
        return this.mixinAction.getParameterCount();
    }

    @Override
    protected synchronized List<ObjectActionParameter> determineParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        List<ObjectActionParameter> mixinActionParameters = this.mixinAction.getParameters();
        List<FacetedMethodParameter> paramPeers = this.getFacetedMethod().getParameters();
        ArrayList mixedInParameters = _Lists.newArrayList();
        for (int paramNum = 0; paramNum < mixinActionParameters.size(); ++paramNum) {
            ObjectActionParameterAbstract mixinParameter = (ObjectActionParameterAbstract)mixinActionParameters.get(paramNum);
            TypedHolder paramPeer = paramPeers.get(paramNum);
            ObjectSpecification specification = ObjectMemberAbstract.getSpecification(this.getSpecificationLoader(), paramPeer.getType());
            ObjectActionParameterMixedInAbstract mixedInParameter = mixinParameter.getPeer().getFeatureType() == FeatureType.ACTION_PARAMETER_SCALAR ? new OneToOneActionParameterMixedIn(mixinParameter, this) : new OneToManyActionParameterMixedIn(mixinParameter, this);
            mixedInParameters.add(mixedInParameter);
        }
        return mixedInParameters;
    }

    @Override
    public Consent isVisible(ManagedObject mixedInAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        VisibilityContext<?> ic = this.mixinAction.createVisibleInteractionContext(mixinAdapter, interactionInitiatedBy, where);
        ic.setMixedIn(mixedInAdapter);
        return InteractionUtils.isVisibleResult(this, ic).createConsent();
    }

    @Override
    public Consent isUsable(ManagedObject mixedInAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        UsabilityContext<?> ic = this.mixinAction.createUsableInteractionContext(mixinAdapter, interactionInitiatedBy, where);
        ic.setMixedIn(mixedInAdapter);
        return InteractionUtils.isUsableResult(this, ic).createConsent();
    }

    @Override
    public ObjectAdapter[] getDefaults(ObjectAdapter mixedInAdapter) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(mixedInAdapter);
        return this.mixinAction.getDefaults(mixinAdapter);
    }

    @Override
    public ObjectAdapter[][] getChoices(ObjectAdapter mixedInAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter mixinAdapter = this.mixinAdapterFor(mixedInAdapter);
        return this.mixinAction.getChoices(mixinAdapter, interactionInitiatedBy);
    }

    protected ObjectAdapter mixinAdapterFor(ObjectAdapter mixedInAdapter) {
        return this.mixinAdapterFor(this.mixinType, mixedInAdapter);
    }

    @Override
    protected void validateArgumentSet(ObjectAdapter mixedInAdapter, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy, InteractionResultSet resultSet) {
        ObjectAdapter targetObject = this.mixinAdapterFor(this.mixinType, mixedInAdapter);
        ActionValidityContext ic = this.mixinAction.createActionInvocationInteractionContext(targetObject, proposedArguments, interactionInitiatedBy);
        ic.setMixedIn(mixedInAdapter);
        InteractionUtils.isValidResultSet(this, ic, resultSet);
    }

    @Override
    public ObjectAdapter execute(ObjectAdapter target, ObjectAdapter mixedInAdapter, ObjectAdapter[] arguments, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter targetAdapter = this.mixinAdapterFor(this.mixinType, target);
        ObjectAdapter actualMixedInAdapter = target;
        this.setupCommand(actualMixedInAdapter, arguments);
        return this.mixinAction.executeInternal(targetAdapter, actualMixedInAdapter, arguments, interactionInitiatedBy);
    }

    @Override
    protected FacetHolder getFacetHolder() {
        return this.facetHolder;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ObjectSpecification getMixinType() {
        return this.getSpecificationLoader().loadSpecification(this.mixinType);
    }
}

