/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.specimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.isis.applib.ApplicationException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.exceptions.UnknownTypeException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResultSet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.actions.prototype.PrototypeFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.interactions.ActionArgValidityContext;
import org.apache.isis.core.metamodel.interactions.ActionUsabilityContext;
import org.apache.isis.core.metamodel.interactions.ActionValidityContext;
import org.apache.isis.core.metamodel.interactions.ActionVisibilityContext;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.UsabilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ActionType;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionParameterAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectMemberAbstract;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToManyActionParameterDefault;
import org.apache.isis.core.metamodel.specloader.specimpl.OneToOneActionParameterDefault;
import org.apache.isis.schema.cmd.v1.CommandDto;

public class ObjectActionDefault
extends ObjectMemberAbstract
implements ObjectAction {
    List<ObjectActionParameter> parameters;
    private static ThreadLocal<List<ObjectAdapter>> commandTargetAdaptersHolder = new ThreadLocal();

    public static ActionType getType(String typeStr) {
        ActionType type = ActionType.valueOf(typeStr);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public ObjectActionDefault(FacetedMethod facetedMethod, ServicesInjector servicesInjector) {
        super(facetedMethod, FeatureType.ACTION, servicesInjector);
    }

    @Override
    public ObjectSpecification getSpecification() {
        return null;
    }

    @Override
    public ObjectSpecification getReturnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getReturnType();
    }

    @Override
    public boolean hasReturn() {
        if (this.getReturnType() == null) {
            return false;
        }
        return this.getReturnType() != this.getSpecificationLoader().loadSpecification(Void.TYPE);
    }

    @Override
    public ObjectSpecification getOnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getOnType();
    }

    @Override
    public SemanticsOf getSemantics() {
        ActionSemanticsFacet facet = this.getFacet(ActionSemanticsFacet.class);
        return facet != null ? (SemanticsOf)facet.value() : SemanticsOf.NON_IDEMPOTENT;
    }

    @Override
    public ActionType getType() {
        return ObjectActionDefault.getType(this);
    }

    private static ActionType getType(FacetHolder facetHolder) {
        PrototypeFacet facet = facetHolder.getFacet(PrototypeFacet.class);
        if (facet != null) {
            return ActionType.PROTOTYPE;
        }
        return ActionType.USER;
    }

    @Override
    public int getParameterCount() {
        return this.getFacetedMethod().getParameters().size();
    }

    @Override
    public List<ObjectActionParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.determineParameters();
        }
        return this.parameters;
    }

    protected synchronized List<ObjectActionParameter> determineParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        int parameterCount = this.getParameterCount();
        List<FacetedMethodParameter> paramPeers = this.getFacetedMethod().getParameters();
        ArrayList parameters = _Lists.newArrayList();
        for (int paramNum = 0; paramNum < parameterCount; ++paramNum) {
            FacetedMethodParameter paramPeer = paramPeers.get(paramNum);
            ObjectSpecification specification = ObjectMemberAbstract.getSpecification(this.getSpecificationLoader(), paramPeer.getType());
            ObjectActionParameterAbstract parameter = paramPeer.getFeatureType() == FeatureType.ACTION_PARAMETER_SCALAR ? new OneToOneActionParameterDefault(paramNum, this, paramPeer) : new OneToManyActionParameterDefault(paramNum, this, paramPeer);
            parameters.add(parameter);
        }
        return parameters;
    }

    @Override
    public List<ObjectSpecification> getParameterTypes() {
        ArrayList parameterTypes = _Lists.newArrayList();
        List<ObjectActionParameter> parameters = this.getParameters();
        for (ObjectActionParameter parameter : parameters) {
            parameterTypes.add(parameter.getSpecification());
        }
        return parameterTypes;
    }

    @Override
    public ObjectActionParameter getParameterById(String paramId) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        for (int i = 0; i < allParameters.size(); ++i) {
            ObjectActionParameter param = allParameters.get(i);
            if (!Objects.equals(paramId, param.getId())) continue;
            return param;
        }
        return null;
    }

    @Override
    public ObjectActionParameter getParameterByName(String paramName) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        for (int i = 0; i < allParameters.size(); ++i) {
            ObjectActionParameter param = allParameters.get(i);
            if (!Objects.equals(paramName, param.getName())) continue;
            return param;
        }
        return null;
    }

    @Override
    public List<ObjectActionParameter> getParameters(Predicate<ObjectActionParameter> predicate) {
        List<ObjectActionParameter> allParameters = this.getParameters();
        ArrayList selectedParameters = _Lists.newArrayList();
        for (int i = 0; i < allParameters.size(); ++i) {
            if (!predicate.test(allParameters.get(i))) continue;
            selectedParameters.add(allParameters.get(i));
        }
        return selectedParameters;
    }

    ObjectActionParameter getParameter(int position) {
        List<ObjectActionParameter> parameters = this.getParameters();
        if (position >= parameters.size()) {
            throw new IllegalArgumentException("getParameter(int): only " + parameters.size() + " parameters, position=" + position);
        }
        return parameters.get(position);
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(ManagedObject targetObjectAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new ActionVisibilityContext(targetObjectAdapter, this, this.getIdentifier(), interactionInitiatedBy, where);
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(ManagedObject targetObjectAdapter, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        return new ActionUsabilityContext(targetObjectAdapter, this, this.getIdentifier(), interactionInitiatedBy, where);
    }

    @Override
    public Consent isProposedArgumentSetValid(ObjectAdapter targetObject, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        InteractionResultSet resultSet = new InteractionResultSet();
        this.validateArgumentsIndividually(targetObject, proposedArguments, interactionInitiatedBy, resultSet);
        if (resultSet.isAllowed()) {
            this.validateArgumentSet(targetObject, proposedArguments, interactionInitiatedBy, resultSet);
        }
        return resultSet.createConsent();
    }

    @Override
    public Consent isEachIndividualArgumentValid(ObjectAdapter objectAdapter, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        InteractionResultSet resultSet = new InteractionResultSet();
        this.validateArgumentsIndividually(objectAdapter, proposedArguments, interactionInitiatedBy, resultSet);
        return resultSet.createConsent();
    }

    private void validateArgumentsIndividually(ObjectAdapter objectAdapter, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy, InteractionResultSet resultSet) {
        List<ObjectActionParameter> actionParameters = this.getParameters();
        if (proposedArguments != null) {
            for (int i = 0; i < proposedArguments.length; ++i) {
                ActionArgValidityContext ic = actionParameters.get(i).createProposedArgumentInteractionContext(objectAdapter, proposedArguments, i, interactionInitiatedBy);
                InteractionUtils.isValidResultSet(this.getParameter(i), ic, resultSet);
            }
        }
    }

    @Override
    public Consent isArgumentSetValid(ObjectAdapter objectAdapter, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        InteractionResultSet resultSet = new InteractionResultSet();
        this.validateArgumentSet(objectAdapter, proposedArguments, interactionInitiatedBy, resultSet);
        return resultSet.createConsent();
    }

    protected void validateArgumentSet(ObjectAdapter objectAdapter, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy, InteractionResultSet resultSet) {
        ActionValidityContext ic = this.createActionInvocationInteractionContext(objectAdapter, proposedArguments, interactionInitiatedBy);
        InteractionUtils.isValidResultSet(this, ic, resultSet);
    }

    ActionValidityContext createActionInvocationInteractionContext(ObjectAdapter targetObject, ObjectAdapter[] proposedArguments, InteractionInitiatedBy interactionInitiatedBy) {
        return new ActionValidityContext(targetObject, this, this.getIdentifier(), proposedArguments, interactionInitiatedBy);
    }

    @Override
    public ObjectAdapter executeWithRuleChecking(ObjectAdapter target, ObjectAdapter mixedInAdapter, ObjectAdapter[] arguments, InteractionInitiatedBy interactionInitiatedBy, Where where) {
        Consent visibility = this.isVisible(target, interactionInitiatedBy, where);
        if (visibility.isVetoed()) {
            throw new ObjectMember.HiddenException();
        }
        Consent usability = this.isUsable(target, interactionInitiatedBy, where);
        if (usability.isVetoed()) {
            throw new ObjectMember.DisabledException(usability.getReason());
        }
        Consent validity = this.isProposedArgumentSetValid(target, arguments, interactionInitiatedBy);
        if (validity.isVetoed()) {
            throw new RecoverableException(validity.getReason());
        }
        return this.execute(target, mixedInAdapter, arguments, interactionInitiatedBy);
    }

    @Override
    public ObjectAdapter execute(ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        this.setupCommand(targetAdapter, argumentAdapters);
        return this.executeInternal(targetAdapter, mixedInAdapter, argumentAdapters, interactionInitiatedBy);
    }

    public ObjectAdapter executeInternal(ObjectAdapter targetAdapter, ObjectAdapter mixedInAdapter, ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        ActionInvocationFacet facet = this.getFacet(ActionInvocationFacet.class);
        return facet.invoke(this, targetAdapter, mixedInAdapter, argumentAdapters, interactionInitiatedBy);
    }

    protected ActionInvocationFacet getActionInvocationFacet() {
        return this.getFacetedMethod().getFacet(ActionInvocationFacet.class);
    }

    @Override
    public ObjectAdapter[] getDefaults(ObjectAdapter target) {
        int i;
        Object[] parameterDefaultPojos;
        int parameterCount = this.getParameterCount();
        List<ObjectActionParameter> parameters = this.getParameters();
        ActionDefaultsFacet facet = this.getFacet(ActionDefaultsFacet.class);
        if (!facet.isNoop()) {
            parameterDefaultPojos = facet.getDefaults(target);
            if (parameterDefaultPojos.length != parameterCount) {
                throw new DomainModelException("Defaults array of incompatible size; expected " + parameterCount + " elements, but was " + parameterDefaultPojos.length + " for " + facet);
            }
            for (i = 0; i < parameterCount; ++i) {
                ObjectSpecification parameterSpec;
                ObjectSpecification componentSpec;
                if (parameterDefaultPojos[i] == null || (componentSpec = this.getSpecificationLoader().loadSpecification(parameterDefaultPojos[i].getClass())).isOfType(parameterSpec = parameters.get(i).getSpecification())) continue;
                throw new DomainModelException("Defaults type incompatible with parameter " + (i + 1) + " type; expected " + parameterSpec.getFullIdentifier() + ", but was " + componentSpec.getFullIdentifier());
            }
        } else {
            parameterDefaultPojos = new Object[parameterCount];
            for (i = 0; i < parameterCount; ++i) {
                ActionParameterDefaultsFacet paramFacet = parameters.get(i).getFacet(ActionParameterDefaultsFacet.class);
                parameterDefaultPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getDefault(target, null) : null;
            }
        }
        ObjectAdapter[] parameterDefaultAdapters = new ObjectAdapter[parameterCount];
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            parameterDefaultAdapters[i2] = this.adapterFor(parameterDefaultPojos[i2]);
        }
        return parameterDefaultAdapters;
    }

    private ObjectAdapter adapterFor(Object pojo) {
        return pojo == null ? null : this.getPersistenceSessionService().adapterFor(pojo);
    }

    public static <T> T withTargetAdapters(List<ObjectAdapter> adapters, Callable<T> callable) {
        commandTargetAdaptersHolder.set(adapters);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
        finally {
            commandTargetAdaptersHolder.set(null);
        }
    }

    @Override
    public ObjectAdapter[][] getChoices(ObjectAdapter target, InteractionInitiatedBy interactionInitiatedBy) {
        Object[][] parameterChoicesPojos;
        int parameterCount = this.getParameterCount();
        ActionChoicesFacet facet = this.getFacet(ActionChoicesFacet.class);
        List<ObjectActionParameter> parameters = this.getParameters();
        if (!facet.isNoop()) {
            parameterChoicesPojos = facet.getChoices(target, interactionInitiatedBy);
            if (parameterChoicesPojos == null) {
                parameterChoicesPojos = new Object[parameterCount][];
            } else if (parameterChoicesPojos.length != parameterCount) {
                throw new DomainModelException(String.format("Choices array of incompatible size; expected %d elements, but was %d for %s", parameterCount, parameterChoicesPojos.length, facet));
            }
        } else {
            parameterChoicesPojos = new Object[parameterCount][];
            for (int i = 0; i < parameterCount; ++i) {
                ActionParameterChoicesFacet paramFacet = parameters.get(i).getFacet(ActionParameterChoicesFacet.class);
                parameterChoicesPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getChoices(target, null, interactionInitiatedBy) : _Constants.emptyObjects;
            }
        }
        ObjectAdapter[][] parameterChoicesAdapters = new ObjectAdapter[parameterCount][];
        for (int i = 0; i < parameterCount; ++i) {
            ObjectSpecification paramSpec = parameters.get(i).getSpecification();
            if (parameterChoicesPojos[i] != null && parameterChoicesPojos[i].length > 0) {
                ObjectActionParameterAbstract.checkChoicesOrAutoCompleteType(this.getSpecificationLoader(), parameterChoicesPojos[i], paramSpec);
                parameterChoicesAdapters[i] = new ObjectAdapter[parameterChoicesPojos[i].length];
                for (int j = 0; j < parameterChoicesPojos[i].length; ++j) {
                    parameterChoicesAdapters[i][j] = this.adapterFor(parameterChoicesPojos[i][j]);
                }
            } else if (paramSpec.isNotCollection()) {
                parameterChoicesAdapters[i] = new ObjectAdapter[0];
            } else {
                throw new UnknownTypeException(paramSpec);
            }
            if (parameterChoicesAdapters[i].length != 0) continue;
            parameterChoicesAdapters[i] = null;
        }
        return parameterChoicesAdapters;
    }

    @Override
    public boolean isPrototype() {
        return this.getType().isPrototype();
    }

    public void setupCommand(ObjectAdapter targetAdapter, ObjectAdapter[] argumentAdapters) {
        this.setupCommandTarget(targetAdapter, argumentAdapters);
        this.setupCommandMemberIdentifier();
        this.setupCommandMementoAndExecutionContext(targetAdapter, argumentAdapters);
    }

    private void setupCommandTarget(ObjectAdapter targetAdapter, ObjectAdapter[] argumentAdapters) {
        String arguments = CommandUtil.argDescriptionFor(this, argumentAdapters);
        this.setupCommandTarget(targetAdapter, arguments);
    }

    private void setupCommandMementoAndExecutionContext(ObjectAdapter targetAdapter, ObjectAdapter[] argumentAdapters) {
        CommandDtoServiceInternal commandDtoServiceInternal = this.getCommandDtoService();
        List<ObjectAdapter> commandTargetAdapters = commandTargetAdaptersHolder.get() != null ? commandTargetAdaptersHolder.get() : Collections.singletonList(targetAdapter);
        CommandDto dto = commandDtoServiceInternal.asCommandDto(commandTargetAdapters, this, argumentAdapters);
        this.setupCommandDtoAndExecutionContext(dto);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action [");
        sb.append(super.toString());
        sb.append(",type=");
        sb.append((Object)this.getType());
        sb.append(",returns=");
        sb.append(this.getReturnType());
        sb.append(",parameters={");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getParameters().get(i).getSpecification().getShortIdentifier());
        }
        sb.append("}]");
        return sb.toString();
    }
}

