/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader.classsubstitutor;

import java.util.Set;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ProxyEnhanced;

public class ClassSubstitutor {
    private final Set<Class<?>> classesToIgnore = _Sets.newHashSet();
    private final Set<String> classNamesToIgnore = _Sets.newHashSet();

    public ClassSubstitutor() {
        this.ignore("org.apache.isis.applib.DomainObjectContainer");
        this.ignore("net.sf.cglib.proxy.Factory");
        this.ignore("net.sf.cglib.proxy.MethodProxy");
        this.ignore("net.sf.cglib.proxy.Callback");
        this.ignore("javassist.util.proxy.ProxyObject");
        this.ignore("javassist.util.proxy.MethodHandler");
    }

    public Class<?> getClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (cls.getName().startsWith("org.datanucleus")) {
            return this.getClass(cls.getSuperclass());
        }
        if (this.shouldIgnore(cls)) {
            return null;
        }
        if (cls.isAnonymousClass()) {
            return cls.getSuperclass();
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null && superclass.isEnum()) {
            return superclass;
        }
        if (ClassUtil.directlyImplements(cls, ProxyEnhanced.class)) {
            return this.getClass(cls.getSuperclass());
        }
        return cls;
    }

    private void ignore(String className) {
        this.classNamesToIgnore.add(className);
    }

    private boolean shouldIgnore(Class<?> cls) {
        if (cls.isArray()) {
            return this.shouldIgnore(cls.getComponentType());
        }
        if (cls.getAnnotation(Programmatic.class) != null) {
            return true;
        }
        try {
            return this.classesToIgnore.contains(cls) || this.classNamesToIgnore.contains(cls.getCanonicalName());
        }
        catch (NoClassDefFoundError e) {
            try {
                if (cls.isAnonymousClass()) {
                    return this.shouldIgnore(cls.getSuperclass());
                }
                return false;
            }
            catch (NoClassDefFoundError ex) {
                return true;
            }
        }
    }
}

