/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

class SpecificationCacheDefault {
    private final Map<String, ObjectSpecification> specByClassName = _Maps.newHashMap();
    private Map<ObjectSpecId, String> classNameBySpecId;

    SpecificationCacheDefault() {
    }

    public ObjectSpecification get(String className) {
        return this.specByClassName.get(className);
    }

    public void cache(String className, ObjectSpecification spec) {
        this.specByClassName.put(className, spec);
        this.recache(spec);
    }

    public void clear() {
        this.specByClassName.clear();
    }

    public Collection<ObjectSpecification> allSpecifications() {
        return Collections.unmodifiableCollection(this.specByClassName.values());
    }

    public ObjectSpecification getByObjectType(ObjectSpecId objectSpecID) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("SpecificationCache by object type has not yet been initialized");
        }
        String className = this.classNameBySpecId.get(objectSpecID);
        return className != null ? this.specByClassName.get(className) : null;
    }

    synchronized void init() {
        HashMap specById = _Maps.newHashMap();
        ArrayList cachedSpecifications = _Lists.newArrayList();
        while (true) {
            ArrayList newSpecifications = _Lists.newArrayList(this.allSpecifications());
            newSpecifications.removeAll(cachedSpecifications);
            if (newSpecifications.isEmpty()) break;
            for (ObjectSpecification objSpec : newSpecifications) {
                ObjectSpecId objectSpecId = objSpec.getSpecId();
                if (objectSpecId == null) continue;
                specById.put(objectSpecId, objSpec);
            }
            cachedSpecifications.addAll(newSpecifications);
        }
        this.internalInit(specById);
    }

    void internalInit(Map<ObjectSpecId, ObjectSpecification> specById) {
        HashMap classNameBySpecId = _Maps.newHashMap();
        HashMap specByClassName = _Maps.newHashMap();
        for (ObjectSpecId objectSpecId : specById.keySet()) {
            ObjectSpecification objectSpec = specById.get(objectSpecId);
            String className = objectSpec.getCorrespondingClass().getName();
            classNameBySpecId.put(objectSpecId, className);
            specByClassName.put(className, objectSpec);
        }
        this.classNameBySpecId = classNameBySpecId;
        this.specByClassName.clear();
        this.specByClassName.putAll(specByClassName);
    }

    public ObjectSpecification remove(String typeName) {
        ObjectSpecification removed = this.specByClassName.remove(typeName);
        if (removed != null && removed.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            ObjectSpecId specId = removed.getSpecId();
            this.classNameBySpecId.remove(specId);
        }
        return removed;
    }

    public void recache(ObjectSpecification spec) {
        if (!this.isInitialized()) {
            return;
        }
        if (!spec.containsDoOpFacet(ObjectSpecIdFacet.class)) {
            return;
        }
        this.classNameBySpecId.put(spec.getSpecId(), spec.getCorrespondingClass().getName());
    }

    boolean isInitialized() {
        return this.classNameBySpecId != null;
    }
}

