/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.specloader;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;

public final class InjectorMethodEvaluatorDefault
implements InjectorMethodEvaluator {
    private final Map<Method, Map<Class<?>, Boolean>> isInjectorMethod = _Maps.newConcurrentHashMap();

    public boolean isInjectorMethodFor(Method method, Class<?> serviceClass) {
        Boolean result;
        ConcurrentHashMap classBooleanMap = this.isInjectorMethod.get(method);
        if (classBooleanMap == null) {
            classBooleanMap = _Maps.newConcurrentHashMap();
            this.isInjectorMethod.put(method, classBooleanMap);
        }
        if ((result = (Boolean)classBooleanMap.get(serviceClass)) == null) {
            result = InjectorMethodEvaluatorDefault.determineIsInjectorMethodFor(method, serviceClass);
            classBooleanMap.put(serviceClass, result);
        }
        return result;
    }

    private static boolean determineIsInjectorMethodFor(Method method, Class<?> serviceClass) {
        Class<?>[] parameterTypes;
        String methodName = method.getName();
        return (methodName.startsWith("set") || methodName.startsWith("inject")) && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0] != Object.class && parameterTypes[0].isAssignableFrom(serviceClass);
    }
}

