/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.WhereValueFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.order.MemberOrderFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.layout.memberorderfacet.MemberOrderComparator;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.CurrentHolder;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.util.DeweyOrderComparator;

public interface ObjectAssociation
extends ObjectMember,
CurrentHolder {
    default public ObjectAdapter get(ObjectAdapter owner) {
        return this.get(owner, InteractionInitiatedBy.USER);
    }

    @Override
    public ObjectAdapter get(ObjectAdapter var1, InteractionInitiatedBy var2);

    public ObjectAdapter getDefault(ObjectAdapter var1);

    public void toDefault(ObjectAdapter var1);

    public boolean hasChoices();

    public ObjectAdapter[] getChoices(ObjectAdapter var1, InteractionInitiatedBy var2);

    public boolean hasAutoComplete();

    public ObjectAdapter[] getAutoComplete(ObjectAdapter var1, String var2, InteractionInitiatedBy var3);

    public int getAutoCompleteMinLength();

    public boolean isNotPersisted();

    public boolean isEmpty(ObjectAdapter var1, InteractionInitiatedBy var2);

    public boolean isMandatory();

    public ObjectSpecification getOnType();

    public static class Util {
        public static final String LAYOUT_DEFAULT_GROUP = "General";

        private Util() {
        }

        public static Map<String, List<ObjectAssociation>> groupByMemberOrderName(List<ObjectAssociation> associations) {
            HashMap associationsByGroup = _Maps.newHashMap();
            for (ObjectAssociation objectAssociation : associations) {
                Util.addAssociationIntoGroup(associationsByGroup, objectAssociation);
            }
            for (Map.Entry entry : associationsByGroup.entrySet()) {
                Collections.sort((List)entry.getValue(), new MemberOrderComparator(true));
            }
            return associationsByGroup;
        }

        private static void addAssociationIntoGroup(Map<String, List<ObjectAssociation>> associationsByGroup, ObjectAssociation association) {
            String untranslatedName;
            MemberOrderFacet memberOrderFacet = association.getFacet(MemberOrderFacet.class);
            if (memberOrderFacet != null && !_Strings.isNullOrEmpty((CharSequence)(untranslatedName = memberOrderFacet.untranslatedName()))) {
                Util.getFrom(associationsByGroup, untranslatedName).add(association);
                return;
            }
            Util.getFrom(associationsByGroup, LAYOUT_DEFAULT_GROUP).add(association);
        }

        private static List<ObjectAssociation> getFrom(Map<String, List<ObjectAssociation>> associationsByGroup, String groupName) {
            ArrayList list = associationsByGroup.get(groupName);
            if (list == null) {
                list = _Lists.newArrayList();
                associationsByGroup.put(groupName, list);
            }
            return list;
        }
    }

    public static class Comparators {
        @Deprecated
        public static Comparator<ObjectAssociation> byMemberOrderSequence() {
            return new Comparator<ObjectAssociation>(){
                private final DeweyOrderComparator deweyOrderComparator = new DeweyOrderComparator();

                @Override
                public int compare(ObjectAssociation o1, ObjectAssociation o2) {
                    MemberOrderFacet o1Facet = o1.getFacet(MemberOrderFacet.class);
                    MemberOrderFacet o2Facet = o2.getFacet(MemberOrderFacet.class);
                    return o1Facet == null ? 1 : (o2Facet == null ? -1 : this.deweyOrderComparator.compare(o1Facet.sequence(), o2Facet.sequence()));
                }
            };
        }
    }

    public static class Predicates {
        public static final Predicate<ObjectAssociation> PROPERTIES = new Predicate<ObjectAssociation>(){

            @Override
            public boolean test(ObjectAssociation association) {
                return association.isOneToOneAssociation();
            }
        };
        public static final Predicate<ObjectAssociation> REFERENCE_PROPERTIES = new Predicate<ObjectAssociation>(){

            @Override
            public boolean test(ObjectAssociation association) {
                return association.isOneToOneAssociation() && !association.getSpecification().containsDoOpFacet(ValueFacet.class);
            }
        };
        public static final Predicate<ObjectAssociation> COLLECTIONS = new Predicate<ObjectAssociation>(){

            @Override
            public boolean test(ObjectAssociation property) {
                return property.isOneToManyAssociation();
            }
        };

        private Predicates() {
        }

        public static final Predicate<ObjectAssociation> staticallyVisible(final Where where) {
            return new Predicate<ObjectAssociation>(){

                @Override
                public boolean test(ObjectAssociation association) {
                    Stream<Facet> facets = association.streamFacets().filter(facet -> facet instanceof WhereValueFacet && facet instanceof HiddenFacet);
                    return !facets.map(facet -> (WhereValueFacet)facet).anyMatch(wawF -> wawF.where().includes(where));
                }
            };
        }
    }

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectAssociation, String> toName() {
            return ObjectFeature::getName;
        }

        public static Function<ObjectAssociation, String> toId() {
            return ObjectFeature::getId;
        }
    }
}

