/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec.feature;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.ActionArgValidityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.CurrentHolder;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.spec.feature.OneToManyActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToOneActionParameter;

public interface ObjectActionParameter
extends ObjectFeature,
CurrentHolder {
    public ObjectAction getAction();

    public boolean isOptional();

    public int getNumber();

    @Override
    public String getName();

    public ActionArgValidityContext createProposedArgumentInteractionContext(ObjectAdapter var1, ObjectAdapter[] var2, int var3, InteractionInitiatedBy var4);

    public boolean hasAutoComplete();

    public ObjectAdapter[] getAutoComplete(ObjectAdapter var1, String var2, InteractionInitiatedBy var3);

    public int getAutoCompleteMinLength();

    public boolean hasChoices();

    public ObjectAdapter[] getChoices(ObjectAdapter var1, ObjectAdapter[] var2, InteractionInitiatedBy var3);

    public ObjectAdapter getDefault(ObjectAdapter var1);

    public String isValid(ObjectAdapter var1, Object var2, InteractionInitiatedBy var3);

    public static class Predicates {
        private Predicates() {
        }

        public static class ScalarParameter
        implements Predicate<ObjectActionParameter> {
            private final ObjectSpecification specification;

            public ScalarParameter(ObjectSpecification specification) {
                this.specification = specification;
            }

            @Override
            public boolean test(@Nullable ObjectActionParameter objectActionParameter) {
                if (!(objectActionParameter instanceof OneToOneActionParameter)) {
                    return false;
                }
                OneToOneActionParameter otoap = (OneToOneActionParameter)objectActionParameter;
                ObjectSpecification paramSecification = otoap.getSpecification();
                return paramSecification == this.specification;
            }
        }

        public static class CollectionParameter
        implements Predicate<ObjectActionParameter> {
            private final ObjectSpecification elementSpecification;

            public CollectionParameter(ObjectSpecification elementSpecification) {
                this.elementSpecification = elementSpecification;
            }

            @Override
            public boolean test(@Nullable ObjectActionParameter objectActionParameter) {
                if (!(objectActionParameter instanceof OneToManyActionParameter)) {
                    return false;
                }
                OneToManyActionParameter otmap = (OneToManyActionParameter)objectActionParameter;
                ObjectSpecification paramElementSpecification = otmap.getSpecification();
                return this.elementSpecification.isOfType(paramElementSpecification);
            }
        }
    }

    public static class Functions {
        public static final Function<ObjectActionParameter, String> GET_NAME = ObjectActionParameter::getName;
        public static final Function<ObjectActionParameter, Class<?>> GET_TYPE = input -> input.getSpecification().getCorrespondingClass();

        private Functions() {
        }
    }
}

