/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.spec;

import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public interface ManagedObject {
    public ObjectSpecification getSpecification();

    public Object getPojo();

    default public String titleString() {
        return this.titleString(null);
    }

    default public String titleString(ObjectAdapter contextAdapterIfAny) {
        return TitleUtil.titleString(this, contextAdapterIfAny);
    }

    @Deprecated
    default public ObjectSpecification getElementSpecification() {
        return this.getSpecification().getElementSpecification();
    }

    @Deprecated
    default public String getIconName() {
        return this.getSpecification().getIconName(this);
    }

    public static ManagedObject of(final ObjectSpecification specification, final Object pojo) {
        return new ManagedObject(){

            @Override
            public ObjectSpecification getSpecification() {
                return specification;
            }

            @Override
            public Object getPojo() {
                return pojo;
            }
        };
    }

    public static ManagedObject of(final Supplier<ObjectSpecification> specificationSupplier, final Object pojo) {
        return new ManagedObject(){
            private final _Lazy<ObjectSpecification> specification;
            {
                this.specification = _Lazy.of((Supplier)specificationSupplier);
            }

            @Override
            public ObjectSpecification getSpecification() {
                return (ObjectSpecification)this.specification.get();
            }

            @Override
            public Object getPojo() {
                return pojo;
            }
        };
    }

    public static class TitleUtil {
        public static String titleString(ManagedObject managedObject, ObjectAdapter contextAdapterIfAny) {
            if (managedObject.getSpecification().isParentedOrFreeCollection()) {
                CollectionFacet facet = managedObject.getSpecification().getFacet(CollectionFacet.class);
                return TitleUtil.collectionTitleString(managedObject, facet);
            }
            return TitleUtil.objectTitleString(managedObject, contextAdapterIfAny);
        }

        private static String objectTitleString(ManagedObject managedObject, ObjectAdapter contextAdapterIfAny) {
            if (managedObject.getPojo() instanceof String) {
                return (String)managedObject.getPojo();
            }
            ObjectSpecification specification = managedObject.getSpecification();
            String title = specification.getTitle(contextAdapterIfAny, managedObject);
            if (title == null) {
                title = TitleUtil.getDefaultTitle(managedObject);
            }
            return title;
        }

        private static String collectionTitleString(ManagedObject managedObject, CollectionFacet facet) {
            int size = facet.size(managedObject);
            ObjectSpecification elementSpecification = managedObject.getElementSpecification();
            if (elementSpecification == null || elementSpecification.getFullIdentifier().equals(Object.class.getName())) {
                switch (size) {
                    case -1: {
                        return "Objects";
                    }
                    case 0: {
                        return "No objects";
                    }
                    case 1: {
                        return "1 object";
                    }
                }
                return size + " objects";
            }
            switch (size) {
                case -1: {
                    return elementSpecification.getPluralName();
                }
                case 0: {
                    return "No " + elementSpecification.getPluralName();
                }
                case 1: {
                    return "1 " + elementSpecification.getSingularName();
                }
            }
            return size + " " + elementSpecification.getPluralName();
        }

        private static String getDefaultTitle(ManagedObject managedObject) {
            return "A" + (" " + managedObject.getSpecification().getSingularName()).toLowerCase();
        }
    }
}

