/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.title;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.title.TitleService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class TitleServiceDefault
implements TitleService {
    @Inject
    PersistenceSessionServiceInternal sessionServiceInternal;
    @Inject
    WrapperFactory wrapperFactory;

    @Programmatic
    public String titleOf(Object domainObject) {
        ObjectAdapter objectAdapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(domainObject));
        boolean destroyed = objectAdapter.isDestroyed();
        if (!destroyed) {
            return objectAdapter.getSpecification().getTitle(null, objectAdapter);
        }
        return "[DELETED]";
    }

    @Programmatic
    public String iconNameOf(Object domainObject) {
        ObjectAdapter objectAdapter = this.getObjectAdapterProvider().adapterFor(this.unwrapped(domainObject));
        return objectAdapter.getSpecification().getIconName(objectAdapter);
    }

    private Object unwrapped(Object domainObject) {
        return this.wrapperFactory != null ? this.wrapperFactory.unwrap(domainObject) : domainObject;
    }

    private ObjectAdapterProvider getObjectAdapterProvider() {
        return this.sessionServiceInternal;
    }
}

