/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.context._Plugin;
import org.apache.isis.core.metamodel.services.swagger.internal.ValuePropertyPlugin;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ValuePropertyFactory {
    private final Map<Class<?>, Factory> propertyFactoryByClass = _Maps.newHashMap();

    public ValuePropertyFactory() {
        this.propertyFactoryByClass.put(Boolean.TYPE, BooleanProperty::new);
        this.propertyFactoryByClass.put(Boolean.class, BooleanProperty::new);
        this.propertyFactoryByClass.put(Byte.TYPE, IntegerProperty::new);
        this.propertyFactoryByClass.put(Byte.class, IntegerProperty::new);
        this.propertyFactoryByClass.put(Short.TYPE, IntegerProperty::new);
        this.propertyFactoryByClass.put(Short.class, IntegerProperty::new);
        this.propertyFactoryByClass.put(Integer.TYPE, IntegerProperty::new);
        this.propertyFactoryByClass.put(Integer.class, IntegerProperty::new);
        this.propertyFactoryByClass.put(BigInteger.class, IntegerProperty::new);
        this.propertyFactoryByClass.put(Long.TYPE, LongProperty::new);
        this.propertyFactoryByClass.put(Long.class, LongProperty::new);
        this.propertyFactoryByClass.put(Timestamp.class, LongProperty::new);
        this.propertyFactoryByClass.put(BigDecimal.class, DecimalProperty::new);
        this.propertyFactoryByClass.put(Float.TYPE, FloatProperty::new);
        this.propertyFactoryByClass.put(Float.class, FloatProperty::new);
        this.propertyFactoryByClass.put(Double.TYPE, DoubleProperty::new);
        this.propertyFactoryByClass.put(Double.class, DoubleProperty::new);
        this.propertyFactoryByClass.put(Character.TYPE, StringProperty::new);
        this.propertyFactoryByClass.put(Character.class, StringProperty::new);
        this.propertyFactoryByClass.put(char[].class, StringProperty::new);
        this.propertyFactoryByClass.put(String.class, StringProperty::new);
        this.propertyFactoryByClass.put(UUID.class, UUIDProperty::new);
        this.propertyFactoryByClass.put(java.util.Date.class, DateTimeProperty::new);
        this.propertyFactoryByClass.put(DateTime.class, DateTimeProperty::new);
        this.propertyFactoryByClass.put(LocalDateTime.class, DateTimeProperty::new);
        this.propertyFactoryByClass.put(Date.class, DateProperty::new);
        this.propertyFactoryByClass.put(LocalDate.class, DateProperty::new);
        this.propertyFactoryByClass.put(byte[].class, ByteArrayProperty::new);
        this.propertyFactoryByClass.put(Blob.class, ByteArrayProperty::new);
        ValuePropertyFactory.discoverValueProperties().visitEntries(this.propertyFactoryByClass::put);
    }

    public Property newProperty(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        Factory factory = this.propertyFactoryByClass.get(cls);
        if (factory != null) {
            return (Property)factory.get();
        }
        if (cls.isEnum()) {
            StringProperty property = new StringProperty();
            ?[] enumConstants = cls.getEnumConstants();
            List enumNames = _Lists.map(Arrays.asList(enumConstants), input -> ((Enum)input).name());
            property.setEnum(enumNames);
            return property;
        }
        return null;
    }

    private static ValuePropertyPlugin.ValuePropertyCollector discoverValueProperties() {
        Set plugins = _Plugin.loadAll(ValuePropertyPlugin.class);
        ValuePropertyPlugin.ValuePropertyCollector collector = ValuePropertyPlugin.collector();
        plugins.forEach(plugin -> plugin.plugin(collector));
        return collector;
    }

    public static interface Factory
    extends Supplier<Property> {
    }
}

