/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.core.metamodel.services.swagger.internal.Generation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class SwaggerSpecGenerator {
    private final SpecificationLoader specificationLoader;

    public SwaggerSpecGenerator(SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
    }

    public String generate(String basePath, SwaggerService.Visibility visibility, SwaggerService.Format format) {
        Generation generation = this.newGeneration(basePath, visibility);
        Swagger swagger = generation.generate();
        switch (format) {
            case JSON: {
                return Json.pretty((Object)swagger);
            }
            case YAML: {
                try {
                    return Yaml.pretty().writeValueAsString((Object)swagger);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new IllegalArgumentException("Unrecognized format: " + format);
    }

    protected Generation newGeneration(String basePath, SwaggerService.Visibility visibility) {
        return new Generation(basePath, visibility, this.specificationLoader);
    }
}

