/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.swagger;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.core.metamodel.services.swagger.internal.SwaggerSpecGenerator;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class SwaggerServiceDefault
implements SwaggerService {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerServiceDefault.class);
    private String basePath;
    @Inject
    SpecificationLoader specificationLoader;

    @PostConstruct
    public void init() {
        String restfulPath = (String)_With.ifPresentElse((Object)_Resources.getRestfulPathIfAny(), (Object)"undefined");
        this.basePath = _Strings.prefix((String)_Resources.prependContextPathIfPresent((String)restfulPath), (String)"/");
    }

    @Programmatic
    public String generateSwaggerSpec(SwaggerService.Visibility visibility, SwaggerService.Format format) {
        SwaggerSpecGenerator swaggerSpecGenerator = new SwaggerSpecGenerator(this.specificationLoader);
        String swaggerSpec = swaggerSpecGenerator.generate(this.basePath, visibility, format);
        return swaggerSpec;
    }
}

