/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.metamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifest2;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.applib.services.metamodel.DomainModel;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.JdoMetamodelUtil;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.core.metamodel.services.appmanifest.AppManifestProvider;
import org.apache.isis.core.metamodel.services.metamodel.DomainMemberDefault;
import org.apache.isis.core.metamodel.services.metamodel.DomainModelDefault;
import org.apache.isis.core.metamodel.services.metamodel.MetaModelExporter;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class MetaModelServiceDefault
implements MetaModelService {
    private static final Logger LOG = LoggerFactory.getLogger(MetaModelServiceDefault.class);
    private MetaModelExporter metaModelExporter;
    @Inject
    SpecificationLoader specificationLookup;
    @Inject
    GridService gridService;
    @Inject
    AppManifestProvider appManifestProvider;

    @PostConstruct
    @Programmatic
    public void init() {
        this.metaModelExporter = new MetaModelExporter(this.specificationLookup);
    }

    @Programmatic
    public Class<?> fromObjectType(String objectType) {
        if (objectType == null) {
            return null;
        }
        ObjectSpecId objectSpecId = ObjectSpecId.of(objectType);
        ObjectSpecification objectSpecification = this.specificationLookup.lookupBySpecId(objectSpecId);
        return objectSpecification != null ? objectSpecification.getCorrespondingClass() : null;
    }

    public String toObjectType(Class<?> domainType) {
        if (domainType == null) {
            return null;
        }
        ObjectSpecification objectSpecification = this.specificationLookup.loadSpecification(domainType);
        ObjectSpecIdFacet objectSpecIdFacet = objectSpecification.getFacet(ObjectSpecIdFacet.class);
        ObjectSpecId objectSpecId = objectSpecIdFacet.value();
        return objectSpecId.asString();
    }

    public void rebuild(Class<?> domainType) {
        this.specificationLookup.invalidateCache(domainType);
        this.gridService.remove(domainType);
        this.specificationLookup.loadSpecification(domainType);
    }

    @Programmatic
    public DomainModel getDomainModel() {
        List<ObjectSpecification> specifications = this.specificationLookup.allSpecifications();
        ArrayList rows = _Lists.newArrayList();
        for (ObjectSpecification spec : specifications) {
            if (this.exclude(spec)) continue;
            Stream<ObjectAssociation> properties = spec.streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
            properties.map(property -> (OneToOneAssociation)property).filter(otoa -> !this.exclude((OneToOneAssociation)otoa)).forEach(otoa -> rows.add(new DomainMemberDefault(spec, (OneToOneAssociation)otoa)));
            Stream<ObjectAssociation> associations = spec.streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.COLLECTIONS);
            associations.map(collection -> (OneToManyAssociation)collection).filter(otma -> !this.exclude((OneToManyAssociation)otma)).forEach(otma -> rows.add(new DomainMemberDefault(spec, (OneToManyAssociation)otma)));
            Stream<ObjectAction> actions = spec.streamObjectActions(Contributed.INCLUDED);
            actions.filter(action -> !this.exclude((ObjectAction)action)).forEach(action -> rows.add(new DomainMemberDefault(spec, (ObjectAction)action)));
        }
        Collections.sort(rows);
        return new DomainModelDefault(rows);
    }

    protected boolean exclude(OneToOneAssociation property) {
        return false;
    }

    protected boolean exclude(OneToManyAssociation collection) {
        return false;
    }

    protected boolean exclude(ObjectAction action) {
        return false;
    }

    protected boolean exclude(ObjectSpecification spec) {
        return this.isBuiltIn(spec) || spec.isAbstract() || spec.isMixin();
    }

    protected boolean isBuiltIn(ObjectSpecification spec) {
        String className = spec.getFullIdentifier();
        return className.startsWith("java") || className.startsWith("org.joda");
    }

    public MetaModelService.Sort sortOf(Class<?> domainType, MetaModelService.Mode mode) {
        if (domainType == null) {
            return null;
        }
        ObjectSpecification objectSpec = this.specificationLookup.loadSpecification(domainType);
        if (objectSpec.isService()) {
            return MetaModelService.Sort.DOMAIN_SERVICE;
        }
        if (objectSpec.isViewModel()) {
            return MetaModelService.Sort.VIEW_MODEL;
        }
        if (objectSpec.isValue()) {
            return MetaModelService.Sort.VALUE;
        }
        if (objectSpec.isMixin()) {
            return MetaModelService.Sort.VALUE;
        }
        if (objectSpec.isParentedOrFreeCollection()) {
            return MetaModelService.Sort.COLLECTION;
        }
        Class<?> correspondingClass = objectSpec.getCorrespondingClass();
        if (JdoMetamodelUtil.isPersistenceEnhanced(correspondingClass)) {
            return MetaModelService.Sort.JDO_ENTITY;
        }
        if (mode == MetaModelService.Mode.RELAXED) {
            return MetaModelService.Sort.UNKNOWN;
        }
        throw new IllegalArgumentException(String.format("Unable to determine what sort of domain object this is: '%s'. Originating domainType: '%s'", objectSpec.getFullIdentifier(), domainType.getName()));
    }

    public MetaModelService.Sort sortOf(Bookmark bookmark, MetaModelService.Mode mode) {
        Class<?> domainType;
        if (bookmark == null) {
            return null;
        }
        switch (mode) {
            case RELAXED: {
                try {
                    domainType = this.fromObjectType(bookmark.getObjectType());
                    break;
                }
                catch (Exception e) {
                    return MetaModelService.Sort.UNKNOWN;
                }
            }
            default: {
                domainType = this.fromObjectType(bookmark.getObjectType());
            }
        }
        return this.sortOf(domainType, mode);
    }

    public CommandDtoProcessor commandDtoProcessorFor(String memberIdentifier) {
        ApplicationFeatureId featureId = ApplicationFeatureId.newFeature(ApplicationFeatureType.MEMBER, memberIdentifier);
        ObjectSpecId objectSpecId = featureId.getObjectSpecId();
        if (objectSpecId == null) {
            return null;
        }
        ObjectSpecification spec = this.specificationLookup.lookupBySpecId(objectSpecId);
        if (spec == null) {
            return null;
        }
        ObjectMember objectMemberIfAny = spec.getMember(featureId.getMemberName());
        if (objectMemberIfAny == null) {
            return null;
        }
        CommandFacet commandFacet = objectMemberIfAny.getFacet(CommandFacet.class);
        if (commandFacet == null) {
            return null;
        }
        return commandFacet.getProcessor();
    }

    public AppManifest2 getAppManifest2() {
        AppManifest appManifest = this.getAppManifest();
        return appManifest instanceof AppManifest2 ? (AppManifest2)appManifest : null;
    }

    public AppManifest getAppManifest() {
        return this.appManifestProvider.getAppManifest();
    }

    public MetamodelDto exportMetaModel(MetaModelService.Config config) {
        return this.metaModelExporter.exportMetaModel(config);
    }
}

