/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.metamodel;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.actions.validate.ActionValidationFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.validating.PropertyValidateFacet;
import org.apache.isis.core.metamodel.services.devutils.MemberType;
import org.apache.isis.core.metamodel.spec.Hierarchical;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.specimpl.ContributeeMember;
import org.apache.isis.core.metamodel.specloader.specimpl.MixedInMember;

@XmlRootElement(name="domain-member")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DomainMemberDefault
implements DomainMember {
    private final ObjectSpecification spec;
    private final MemberType memberType;
    private final ObjectMember member;
    private ObjectAction action;
    private static final Comparator<DomainMember> comparator = Comparator.comparing(DomainMember::getClassType).thenComparing(DomainMember::getClassName).thenComparing(DomainMember::getType, Comparator.reverseOrder()).thenComparing(DomainMember::getMemberName);

    DomainMemberDefault() {
        throw _Exceptions.unexpectedCodeReach();
    }

    DomainMemberDefault(ObjectSpecification spec, OneToOneAssociation property) {
        this.spec = spec;
        this.member = property;
        this.memberType = MemberType.PROPERTY;
    }

    DomainMemberDefault(ObjectSpecification spec, OneToManyAssociation collection) {
        this.spec = spec;
        this.member = collection;
        this.memberType = MemberType.COLLECTION;
    }

    DomainMemberDefault(ObjectSpecification spec, ObjectAction action) {
        this.spec = spec;
        this.action = action;
        this.member = this.action;
        this.memberType = MemberType.ACTION;
    }

    @XmlElement
    public String getClassType() {
        boolean service = false;
        for (ObjectSpecification subspecs : this.spec.subclasses(Hierarchical.Depth.DIRECT)) {
            service = service || subspecs.isService();
        }
        return service || this.spec.isService() ? "2 Service" : (this.spec.isValue() ? "3 Value" : (this.spec.isParentedOrFreeCollection() ? "4 Collection" : "1 Object"));
    }

    @XmlElement
    public String getClassName() {
        String fullIdentifier = this.spec.getFullIdentifier();
        int lastDot = fullIdentifier.lastIndexOf(".");
        return lastDot > 0 && lastDot < fullIdentifier.length() - 1 ? fullIdentifier.substring(lastDot + 1, fullIdentifier.length()) : fullIdentifier;
    }

    @XmlElement
    public String getPackageName() {
        String fullIdentifier = this.spec.getFullIdentifier();
        int lastDot = fullIdentifier.lastIndexOf(".");
        return lastDot > 0 ? fullIdentifier.substring(0, lastDot) : fullIdentifier;
    }

    @XmlElement
    public String getType() {
        return this.memberType.name().toLowerCase();
    }

    @XmlElement
    public String getMemberName() {
        return this.member.getId();
    }

    @XmlElement
    public String getNumParams() {
        return this.action != null ? "" + this.action.getParameterCount() : "";
    }

    @XmlElement
    public boolean isContributed() {
        return this.member instanceof ContributeeMember;
    }

    @XmlElement
    public String getContributedBy() {
        if (this.member instanceof ContributeeMember) {
            ObjectSpecification serviceContributedBy = ((ContributeeMember)this.member).getServiceContributedBy();
            return serviceContributedBy.getCorrespondingClass().getSimpleName();
        }
        return "";
    }

    @XmlElement
    public boolean isMixedIn() {
        return this.member instanceof MixedInMember;
    }

    @XmlElement
    public String getMixin() {
        if (this.member instanceof MixedInMember) {
            MixedInMember mixedInMember = (MixedInMember)this.member;
            ObjectSpecification mixinType = mixedInMember.getMixinType();
            return mixinType.getCorrespondingClass().getSimpleName();
        }
        return "";
    }

    @XmlElement
    public String getHidden() {
        return this.interpret(HiddenFacet.class);
    }

    @XmlElement
    public String getDisabled() {
        return this.interpret(DisabledFacet.class);
    }

    @XmlElement
    public String getChoices() {
        switch (this.memberType) {
            case PROPERTY: {
                return this.interpretRowAndFacet(PropertyChoicesFacet.class);
            }
            case COLLECTION: {
                return "";
            }
        }
        List<ObjectActionParameter> parameters = this.action.getParameters();
        TreeSet interpretations = _Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterChoicesFacet facet = param.getFacet(ActionParameterChoicesFacet.class);
            DomainMemberDefault.addIfNotEmpty(DomainMemberDefault.interpretFacet(facet), interpretations);
        }
        return !interpretations.isEmpty() ? interpretations.stream().collect(Collectors.joining(";")) : this.interpretRowAndFacet(ActionChoicesFacet.class);
    }

    @XmlElement
    public String getAutoComplete() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyAutoCompleteFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            return "";
        }
        List<ObjectActionParameter> parameters = this.action.getParameters();
        TreeSet interpretations = _Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterAutoCompleteFacet facet = param.getFacet(ActionParameterAutoCompleteFacet.class);
            DomainMemberDefault.addIfNotEmpty(DomainMemberDefault.interpretFacet(facet), interpretations);
        }
        return interpretations.stream().collect(Collectors.joining(";"));
    }

    @XmlElement
    public String getDefault() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyDefaultFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            return "";
        }
        List<ObjectActionParameter> parameters = this.action.getParameters();
        TreeSet interpretations = _Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterDefaultsFacet facet = param.getFacet(ActionParameterDefaultsFacet.class);
            DomainMemberDefault.addIfNotEmpty(DomainMemberDefault.interpretFacet(facet), interpretations);
        }
        return !interpretations.isEmpty() ? interpretations.stream().collect(Collectors.joining(";")) : this.interpretRowAndFacet(ActionDefaultsFacet.class);
    }

    @XmlElement
    public String getValidate() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyValidateFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            TreeSet interpretations = _Sets.newTreeSet();
            DomainMemberDefault.addIfNotEmpty(this.interpretRowAndFacet(CollectionValidateAddToFacet.class), interpretations);
            DomainMemberDefault.addIfNotEmpty(this.interpretRowAndFacet(CollectionValidateRemoveFromFacet.class), interpretations);
            return interpretations.stream().collect(Collectors.joining(";"));
        }
        return this.interpretRowAndFacet(ActionValidationFacet.class);
    }

    public int compareTo(DomainMember o) {
        return comparator.compare(this, o);
    }

    private String interpretRowAndFacet(Class<? extends Facet> facetClass) {
        Facet facet = this.member.getFacet(facetClass);
        return DomainMemberDefault.interpretFacet(facet);
    }

    private static void addIfNotEmpty(String str, SortedSet<String> set) {
        if (!_Strings.isNullOrEmpty((CharSequence)str)) {
            set.add(str);
        }
    }

    private String interpret(Class<? extends Facet> cls) {
        return DomainMemberDefault.interpretFacet(this.member.getFacet(cls));
    }

    private static String interpretFacet(Facet facet) {
        if (facet == null || facet.isNoop()) {
            return "";
        }
        if (facet instanceof ImperativeFacet) {
            ImperativeFacet imperativeFacet = (ImperativeFacet)facet;
            return imperativeFacet.getMethods().get(0).getName();
        }
        String name = facet.getClass().getSimpleName();
        if (DomainMemberDefault.ignore(name)) {
            return "";
        }
        return name;
    }

    protected static boolean ignore(String name) {
        return Arrays.asList("PropertyValidateFacetDefault", "PropertyDefaultFacetDerivedFromDefaultedFacet").contains(name);
    }
}

