/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.layout;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.isis.applib.FatalException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.services.grid.GridService;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.services.layout.LayoutService2;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class LayoutServiceDefault
implements LayoutService2 {
    @Inject
    SpecificationLoader specificationLoader;
    @Inject
    JaxbService jaxbService;
    @Inject
    GridService gridService;
    @Inject
    MenuBarsService menuBarsService;

    public String toXml(Class<?> domainClass, LayoutService.Style style) {
        Grid grid = this.toGrid(domainClass, style);
        return this.jaxbService.toXml((Object)grid, _Maps.unmodifiable((Object)"jaxb.schemaLocation", (Object)grid.getTnsAndSchemaLocation()));
    }

    protected Grid toGrid(Class<?> domainClass, LayoutService.Style style) {
        if (style == LayoutService.Style.CURRENT) {
            ObjectSpecification objectSpec = this.specificationLoader.loadSpecification(domainClass);
            GridFacet facet = objectSpec.getFacet(GridFacet.class);
            return facet != null ? facet.getGrid(null) : null;
        }
        Grid grid = this.gridService.load(domainClass);
        if (grid == null) {
            grid = this.gridService.defaultGridFor(domainClass);
        }
        this.gridService.normalize(grid);
        if (style == LayoutService.Style.NORMALIZED) {
            return grid;
        }
        if (style == LayoutService.Style.COMPLETE) {
            return this.gridService.complete(grid);
        }
        if (style == LayoutService.Style.MINIMAL) {
            return this.gridService.minimal(grid);
        }
        throw new IllegalArgumentException("unsupported style");
    }

    @Programmatic
    public byte[] toZip(LayoutService.Style style) {
        byte[] bytes;
        List<ObjectSpecification> allSpecs = this.specificationLoader.allSpecifications();
        List domainObjectSpecs = _Lists.filter(allSpecs, input -> !input.isAbstract() && (input.containsDoOpFacet(JdoPersistenceCapableFacet.class) || input.containsDoOpFacet(ViewModelFacet.class)));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            OutputStreamWriter writer = new OutputStreamWriter(zos);
            for (ObjectSpecification objectSpec : domainObjectSpecs) {
                Class<?> domainClass = objectSpec.getCorrespondingClass();
                Grid grid = this.toGrid(domainClass, style);
                if (grid == null) continue;
                zos.putNextEntry(new ZipEntry(LayoutServiceDefault.zipEntryNameFor(objectSpec)));
                String xml = this.jaxbService.toXml((Object)grid, _Maps.unmodifiable((Object)"jaxb.schemaLocation", (Object)grid.getTnsAndSchemaLocation()));
                writer.write(xml);
                writer.flush();
                zos.closeEntry();
            }
            writer.close();
            bytes = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new FatalException("Unable to create zip of layouts", (Throwable)ex);
        }
        return bytes;
    }

    private static String zipEntryNameFor(ObjectSpecification objectSpec) {
        String fqn = objectSpec.getFullIdentifier();
        return fqn.replace(".", File.separator) + ".layout.xml";
    }

    @Programmatic
    public String toMenuBarsXml(MenuBarsService.Type type) {
        MenuBars menuBars = this.menuBarsService.menuBars(type);
        return this.jaxbService.toXml((Object)menuBars, _Maps.unmodifiable((Object)"jaxb.schemaLocation", (Object)menuBars.getTnsAndSchemaLocation()));
    }
}

