/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.exceprecog;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ExceptionRecognizerDocDefault
implements ExceptionRecognizer {
    private final ExceptionRecognizer recognizer = new ExceptionRecognizerComposite(new ExceptionRecognizer[]{new ExceptionRecognizerForConcurrencyException(), new ExceptionRecognizerForRecoverableException()});
    @Inject
    ServiceRegistry serviceRegistry;

    @Programmatic
    @PostConstruct
    public void init() {
        this.serviceRegistry.injectServicesInto((Object)this.recognizer);
        this.recognizer.init();
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.recognizer.shutdown();
    }

    @Programmatic
    public String recognize(Throwable ex) {
        return this.recognizer.recognize(ex);
    }

    @Programmatic
    public ExceptionRecognizer.Recognition recognize2(Throwable ex) {
        return this.recognizer.recognize2(ex);
    }

    static class ExceptionRecognizerForRecoverableException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForRecoverableException() {
            super(ExceptionRecognizer.Category.CLIENT_ERROR, RecoverableException.class);
        }
    }

    static class ExceptionRecognizerForConcurrencyException
    extends ExceptionRecognizerForType {
        public ExceptionRecognizerForConcurrencyException() {
            super(ExceptionRecognizer.Category.CONCURRENCY, ConcurrencyException.class, ExceptionRecognizerForConcurrencyException.prefix((String)"Another user has just changed this data"));
        }
    }
}

